/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.ImportFinishedEvent;
import com.epam.ta.reportportal.core.integration.ExecuteIntegrationHandler;
import com.epam.ta.reportportal.core.integration.plugin.CreatePluginHandler;
import com.epam.ta.reportportal.core.integration.plugin.DeletePluginHandler;
import com.epam.ta.reportportal.core.integration.plugin.GetPluginHandler;
import com.epam.ta.reportportal.core.integration.plugin.UpdatePluginHandler;
import com.epam.ta.reportportal.model.EntryCreatedRS;
import com.epam.ta.reportportal.model.integration.IntegrationTypeResource;
import com.epam.ta.reportportal.model.integration.UpdatePluginStateRQ;
import com.epam.ta.reportportal.model.launch.LaunchImportRQ;
import com.epam.ta.reportportal.util.ProjectExtractor;
import com.epam.ta.reportportal.ws.reporting.OperationCompletionRS;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/v1/plugin"})
@Tag(name="Plugin", description="Plugins API collection")
public class PluginController {
    private final CreatePluginHandler createPluginHandler;
    private final UpdatePluginHandler updatePluginHandler;
    private final GetPluginHandler getPluginHandler;
    private final DeletePluginHandler deletePluginHandler;
    private final ExecuteIntegrationHandler executeIntegrationHandler;
    private final ProjectExtractor projectExtractor;
    private final MessageBus messageBus;

    @Transactional
    @PostMapping(consumes={"multipart/form-data"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @Operation(summary="Upload new ReportPortal plugin")
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    public EntryCreatedRS uploadPlugin(@NotNull @RequestParam(value="file") MultipartFile pluginFile, @AuthenticationPrincipal ReportPortalUser user) {
        return this.createPluginHandler.uploadPlugin(pluginFile, user);
    }

    @Transactional
    @PutMapping(value={"/{pluginId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Update ReportPortal plugin state")
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    public OperationCompletionRS updatePluginState(@PathVariable(value="pluginId") Long id, @RequestBody @Valid UpdatePluginStateRQ updatePluginStateRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.updatePluginHandler.updatePluginState(id, updatePluginStateRQ, user);
    }

    @Transactional(readOnly=true)
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get all available plugins")
    public List<IntegrationTypeResource> getPlugins(@AuthenticationPrincipal ReportPortalUser user) {
        return this.getPluginHandler.getPlugins();
    }

    @Transactional
    @DeleteMapping(value={"/{pluginId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Delete plugin by id")
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    public OperationCompletionRS deletePlugin(@PathVariable(value="pluginId") Long id, @AuthenticationPrincipal ReportPortalUser user) {
        return this.deletePluginHandler.deleteById(id, user);
    }

    @Transactional
    @PutMapping(value={"{projectName}/{pluginName}/common/{command}"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
    @Operation(summary="Execute command to the plugin instance")
    public Object executePluginCommand(@PathVariable String projectName, @PathVariable(value="pluginName") String pluginName, @PathVariable(value="command") String command, @RequestBody Map<String, Object> executionParams, @AuthenticationPrincipal ReportPortalUser user) {
        return this.executeIntegrationHandler.executeCommand(this.projectExtractor.extractProjectDetails(user, projectName), pluginName, command, executionParams);
    }

    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')||hasRole('ADMINISTRATOR')")
    @PostMapping(value={"/{projectName}/{pluginName}/import"}, consumes={"multipart/form-data"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Send report to the specified plugin for importing")
    public Object executeImportPluginCommand(@AuthenticationPrincipal ReportPortalUser user, @PathVariable String projectName, @PathVariable String pluginName, @RequestParam(value="file") MultipartFile file, @RequestPart(required=false) @Valid LaunchImportRQ launchImportRq) {
        HashMap<String, Object> executionParams = new HashMap<String, Object>();
        executionParams.put("file", file);
        Optional.ofNullable(launchImportRq).ifPresentOrElse(rq -> executionParams.put("entity", launchImportRq), () -> executionParams.put("entity", new LaunchImportRQ()));
        ReportPortalUser.ProjectDetails projectDetails = this.projectExtractor.extractProjectDetails(user, projectName);
        Object importResult = this.executeIntegrationHandler.executeCommand(projectDetails, pluginName, "import", executionParams);
        this.messageBus.publishActivity(new ImportFinishedEvent(user.getUserId(), user.getUsername(), projectDetails.getProjectId(), file.getOriginalFilename()));
        return importResult;
    }

    @Generated
    public PluginController(CreatePluginHandler createPluginHandler, UpdatePluginHandler updatePluginHandler, GetPluginHandler getPluginHandler, DeletePluginHandler deletePluginHandler, ExecuteIntegrationHandler executeIntegrationHandler, ProjectExtractor projectExtractor, MessageBus messageBus) {
        this.createPluginHandler = createPluginHandler;
        this.updatePluginHandler = updatePluginHandler;
        this.getPluginHandler = getPluginHandler;
        this.deletePluginHandler = deletePluginHandler;
        this.executeIntegrationHandler = executeIntegrationHandler;
        this.projectExtractor = projectExtractor;
        this.messageBus = messageBus;
    }
}

