/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller;

import com.epam.ta.reportportal.core.onboarding.OnboardingService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/onboarding"})
@Tag(name="Onboarding", description="Onboardings API collection")
public class OnboardingController {
    private final OnboardingService onboardingService;

    public OnboardingController(OnboardingService onboardingService) {
        this.onboardingService = onboardingService;
    }

    @GetMapping(value={""})
    @Operation(summary="Return onboarding information for page if available, -1 otherwise")
    public Object onBoarding(@RequestParam(value="page", defaultValue="GENERAL") String page) {
        Object data = this.onboardingService.getOnboardingDataForPageIfAvailable(page);
        return data != null ? data : Integer.valueOf(-1);
    }
}

