/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.commons.validation.Suppliers;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.core.analyzer.auto.SearchLogService;
import com.epam.ta.reportportal.core.log.CreateLogHandler;
import com.epam.ta.reportportal.core.log.DeleteLogHandler;
import com.epam.ta.reportportal.core.log.GetLogHandler;
import com.epam.ta.reportportal.core.log.impl.PagedLogResource;
import com.epam.ta.reportportal.entity.log.Log;
import com.epam.ta.reportportal.model.Page;
import com.epam.ta.reportportal.model.log.GetLogsUnderRq;
import com.epam.ta.reportportal.model.log.LogResource;
import com.epam.ta.reportportal.model.log.SearchLogRq;
import com.epam.ta.reportportal.model.log.SearchLogRs;
import com.epam.ta.reportportal.util.ControllerUtils;
import com.epam.ta.reportportal.util.ProjectExtractor;
import com.epam.ta.reportportal.ws.reporting.BatchElementCreatedRS;
import com.epam.ta.reportportal.ws.reporting.BatchSaveOperatingRS;
import com.epam.ta.reportportal.ws.reporting.EntryCreatedAsyncRS;
import com.epam.ta.reportportal.ws.reporting.OperationCompletionRS;
import com.epam.ta.reportportal.ws.reporting.SaveLogRQ;
import com.epam.ta.reportportal.ws.resolver.FilterFor;
import com.epam.ta.reportportal.ws.resolver.SortFor;
import com.google.common.collect.ImmutableMap;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Validator;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.SortDefault;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/v1/{projectName}/log"})
@PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
@Tag(name="Log", description="Logs API collection")
public class LogController {
    private final ProjectExtractor projectExtractor;
    private final CreateLogHandler createLogHandler;
    private final DeleteLogHandler deleteLogHandler;
    private final GetLogHandler getLogHandler;
    private final SearchLogService searchLogService;
    private final Validator validator;

    @Autowired
    public LogController(ProjectExtractor projectExtractor, @Autowired CreateLogHandler createLogHandler, DeleteLogHandler deleteLogHandler, GetLogHandler getLogHandler, SearchLogService searchLogService, Validator validator) {
        this.projectExtractor = projectExtractor;
        this.createLogHandler = createLogHandler;
        this.deleteLogHandler = deleteLogHandler;
        this.getLogHandler = getLogHandler;
        this.searchLogService = searchLogService;
        this.validator = validator;
    }

    @Deprecated
    @PostMapping(consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @Hidden
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')||hasRole('ADMINISTRATOR')")
    public EntryCreatedAsyncRS createLog(@PathVariable String projectName, @RequestBody SaveLogRQ createLogRQ, @AuthenticationPrincipal ReportPortalUser user) {
        ControllerUtils.validateSaveRQ(this.validator, createLogRQ);
        return this.createLogHandler.createLog(createLogRQ, null, this.projectExtractor.extractProjectDetails(user, projectName));
    }

    @PostMapping(value={"/entry"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @Operation(summary="Create log")
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')||hasRole('ADMINISTRATOR')")
    public EntryCreatedAsyncRS createLogEntry(@PathVariable String projectName, @RequestBody SaveLogRQ createLogRQ, @AuthenticationPrincipal ReportPortalUser user) {
        ControllerUtils.validateSaveRQ(this.validator, createLogRQ);
        return this.createLogHandler.createLog(createLogRQ, null, this.projectExtractor.extractProjectDetails(user, projectName));
    }

    @PostMapping(consumes={"multipart/form-data"})
    @Operation(summary="Create log (batching operation)")
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')||hasRole('ADMINISTRATOR')")
    public ResponseEntity<BatchSaveOperatingRS> createLog(@PathVariable String projectName, @RequestPart(value="json_request_part") SaveLogRQ[] createLogRQs, HttpServletRequest request, @AuthenticationPrincipal ReportPortalUser user) {
        MultiValuedMap<String, MultipartFile> uploadedFiles = ControllerUtils.getUploadedFiles(request);
        BatchSaveOperatingRS response = new BatchSaveOperatingRS();
        for (SaveLogRQ createLogRq : createLogRQs) {
            try {
                EntryCreatedAsyncRS responseItem;
                String filename;
                ControllerUtils.validateSaveRQ(this.validator, createLogRq);
                String string = filename = createLogRq.getFile() == null ? null : createLogRq.getFile().getName();
                if (StringUtils.isEmpty((CharSequence)filename)) {
                    responseItem = this.createLog(projectName, createLogRq, user);
                } else {
                    MultipartFile data = ControllerUtils.findByFileName(filename, uploadedFiles);
                    BusinessRule.expect((Object)data, (Predicate)Predicates.notNull()).verify(ErrorType.BINARY_DATA_CANNOT_BE_SAVED, new Object[]{Suppliers.formattedSupplier((String)"There is no request part or file with name {}", (Object[])new Object[]{filename})});
                    responseItem = this.createLogHandler.createLog(createLogRq, data, this.projectExtractor.extractProjectDetails(user, projectName));
                }
                response.addResponse(new BatchElementCreatedRS(responseItem.getId()));
            }
            catch (Exception e) {
                response.addResponse(new BatchElementCreatedRS(ExceptionUtils.getStackTrace((Throwable)e), ExceptionUtils.getMessage((Throwable)e)));
            }
        }
        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
    }

    @RequestMapping(value={"/{logId}"}, method={RequestMethod.DELETE})
    @Operation(summary="Delete log")
    @Transactional
    public OperationCompletionRS deleteLog(@PathVariable String projectName, @PathVariable Long logId, @AuthenticationPrincipal ReportPortalUser user) {
        return this.deleteLogHandler.deleteLog(logId, this.projectExtractor.extractProjectDetails(user, projectName), user);
    }

    @RequestMapping(method={RequestMethod.GET})
    @Operation(summary="Get logs by filter")
    @Transactional(readOnly=true)
    public Page<LogResource> getLogs(@PathVariable String projectName, @RequestParam(value="filter.under.path", required=false) String underPath, @FilterFor(value=Log.class) Filter filter, @SortDefault(value={"logTime"}) @SortFor(value=Log.class) Pageable pageable, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getLogHandler.getLogs(underPath, this.projectExtractor.extractProjectDetails(user, projectName), filter, pageable);
    }

    @PostMapping(value={"/under"})
    @Operation(summary="Get logs under items")
    @Transactional(readOnly=true)
    public Map<Long, List<LogResource>> getLogsUnder(@PathVariable String projectName, @RequestBody GetLogsUnderRq logsUnderRq, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getLogHandler.getLogs(logsUnderRq, this.projectExtractor.extractProjectDetails(user, projectName));
    }

    @GetMapping(value={"/{logId}/page"})
    @Operation(summary="Get logs by filter")
    @Transactional(readOnly=true)
    public Map<String, Serializable> getPageNumber(@PathVariable String projectName, @PathVariable Long logId, @FilterFor(value=Log.class) Filter filter, @SortFor(value=Log.class) Pageable pageable, @AuthenticationPrincipal ReportPortalUser user) {
        return ImmutableMap.builder().put((Object)"number", (Object)this.getLogHandler.getPageNumber(logId, this.projectExtractor.extractProjectDetails(user, projectName), filter, pageable)).build();
    }

    @GetMapping(value={"/{logId}"})
    @Operation(summary="Get log by ID")
    @Transactional(readOnly=true)
    public LogResource getLog(@PathVariable String projectName, @PathVariable String logId, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getLogHandler.getLog(logId, this.projectExtractor.extractProjectDetails(user, projectName), user);
    }

    @Deprecated(since="5.8", forRemoval=true)
    @GetMapping(value={"/uuid/{logId}"})
    @Operation(summary="Get log by UUID (Will be removed in version 6.0)")
    @Transactional(readOnly=true)
    public LogResource getLogByUuid(@PathVariable String projectName, @PathVariable String logId, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getLogHandler.getLog(logId, this.projectExtractor.extractProjectDetails(user, projectName), user);
    }

    @GetMapping(value={"/nested/{parentId}"})
    @Operation(summary="Get nested steps with logs for the parent Test Item")
    @Transactional(readOnly=true)
    public Page<?> getNestedItems(@PathVariable String projectName, @PathVariable Long parentId, @Parameter(required=false) @RequestParam Map<String, String> params, @FilterFor(value=Log.class) Filter filter, @SortFor(value=Log.class) Pageable pageable, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getLogHandler.getNestedItems(parentId, this.projectExtractor.extractProjectDetails(user, projectName), params, (Queryable)filter, pageable);
    }

    @GetMapping(value={"/locations/{parentId}"})
    @Operation(summary="Get next or previous log in test item")
    @Transactional(readOnly=true)
    public List<PagedLogResource> getErrorPage(@PathVariable String projectName, @PathVariable Long parentId, @RequestParam Map<String, String> params, @FilterFor(value=Log.class) Filter filter, @SortFor(value=Log.class) Pageable pageable, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getLogHandler.getLogsWithLocation(parentId, this.projectExtractor.extractProjectDetails(user, projectName), params, (Queryable)filter, pageable);
    }

    @PostMapping(value={"search/{itemId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Search test items with similar error logs")
    public Iterable<SearchLogRs> searchLogs(@PathVariable String projectName, @RequestBody SearchLogRq request, @PathVariable Long itemId, @AuthenticationPrincipal ReportPortalUser user) {
        return this.searchLogService.search(itemId, request, this.projectExtractor.extractProjectDetails(user, projectName));
    }
}

