/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller;

import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.file.DeleteFilesHandler;
import com.epam.ta.reportportal.core.file.GetFileHandler;
import com.epam.ta.reportportal.core.user.EditUserHandler;
import com.epam.ta.reportportal.entity.attachment.BinaryData;
import com.epam.ta.reportportal.util.ProjectExtractor;
import com.epam.ta.reportportal.ws.reporting.OperationCompletionRS;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.constraints.Size;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/v1/data"})
@Tag(name="File Storage", description="Files Storage API collection")
public class FileStorageController {
    private final ProjectExtractor projectExtractor;
    private final EditUserHandler editUserHandler;
    private final GetFileHandler getFileHandler;
    private final DeleteFilesHandler deleteFilesHandler;

    @Autowired
    public FileStorageController(ProjectExtractor projectExtractor, EditUserHandler editUserHandler, GetFileHandler getFileHandler, DeleteFilesHandler deleteFilesHandler) {
        this.projectExtractor = projectExtractor;
        this.editUserHandler = editUserHandler;
        this.getFileHandler = getFileHandler;
        this.deleteFilesHandler = deleteFilesHandler;
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
    @GetMapping(value={"/{projectName}/{dataId}"})
    @Operation(summary="Get file")
    public void getFile(@PathVariable String projectName, @PathVariable(value="dataId") Long dataId, HttpServletResponse response, @AuthenticationPrincipal ReportPortalUser user) {
        this.toResponse(response, this.getFileHandler.loadFileById(dataId, this.projectExtractor.extractProjectDetails(user, projectName)));
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/photo"})
    @Operation(summary="Get photo of current user")
    public void getMyPhoto(@AuthenticationPrincipal ReportPortalUser user, HttpServletResponse response, @RequestParam(value="loadThumbnail", required=false) boolean loadThumbnail) {
        this.toResponse(response, this.getFileHandler.getUserPhoto(user, loadThumbnail));
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'notCustomerPermission')||hasRole('ADMINISTRATOR')")
    @GetMapping(value={"/{projectName}/userphoto"})
    @Operation(summary="Get user's photo")
    public void getUserPhoto(@PathVariable String projectName, @RequestParam(value="login") @Size(min=1, max=128) @Size(min=1, max=128) String username, @RequestParam(value="loadThumbnail", required=false) boolean loadThumbnail, HttpServletResponse response, @AuthenticationPrincipal ReportPortalUser user) {
        BinaryData userPhoto = this.getFileHandler.getUserPhoto(EntityUtils.normalizeId((String)username), user, projectName, loadThumbnail);
        this.toResponse(response, userPhoto);
    }

    @Transactional
    @PostMapping(value={"/photo"}, consumes={"multipart/form-data"})
    @Operation(summary="Upload user's photo")
    public OperationCompletionRS uploadPhoto(@RequestParam(value="file") MultipartFile file, @AuthenticationPrincipal ReportPortalUser user) {
        return this.editUserHandler.uploadPhoto(EntityUtils.normalizeId((String)user.getUsername()), file);
    }

    @Transactional
    @DeleteMapping(value={"/photo"})
    @Operation(summary="Delete user's photo")
    public OperationCompletionRS deletePhoto(@AuthenticationPrincipal ReportPortalUser user) {
        return this.editUserHandler.deletePhoto(EntityUtils.normalizeId((String)user.getUsername()));
    }

    @Transactional
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    @PostMapping(value={"/clean"}, consumes={"multipart/form-data"})
    @Operation(summary="Remove attachments from file storage according to uploaded csv file")
    public OperationCompletionRS removeAttachmentsByCsv(@RequestParam(value="file") MultipartFile file, @AuthenticationPrincipal ReportPortalUser user) {
        return this.deleteFilesHandler.removeFilesByCsv(file);
    }

    private void toResponse(HttpServletResponse response, BinaryData binaryData) {
        block10: {
            if (binaryData.getInputStream() != null) {
                response.setContentType(binaryData.getContentType());
                if (binaryData.getFileName() != null) {
                    response.setHeader("Content-Disposition", "attachment; filename=\"" + binaryData.getFileName() + "\"");
                }
                try (InputStream inputStream = binaryData.getInputStream();){
                    IOUtils.copy((InputStream)inputStream, (OutputStream)response.getOutputStream());
                    break block10;
                }
                catch (IOException e) {
                    throw new ReportPortalException("Unable to retrieve binary data from data storage", (Throwable)e);
                }
            }
            response.setStatus(HttpStatus.NO_CONTENT.value());
        }
    }
}

