/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.core.activityevent.ActivityEventHandler;
import com.epam.ta.reportportal.core.filter.SearchCriteriaService;
import com.epam.ta.reportportal.core.filter.predefined.PredefinedFilterType;
import com.epam.ta.reportportal.entity.activity.Activity;
import com.epam.ta.reportportal.model.ActivityEventResource;
import com.epam.ta.reportportal.model.PagedResponse;
import com.epam.ta.reportportal.model.SearchCriteriaRQ;
import com.epam.ta.reportportal.util.ProjectExtractor;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import java.util.List;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/v1/activities"})
@Tag(name="Activity Event", description="Activity Events API collection")
public class ActivityEventController {
    private final ActivityEventHandler activityEventHandler;
    private final ProjectExtractor projectExtractor;
    private final SearchCriteriaService searchCriteriaService;

    public ActivityEventController(ActivityEventHandler activityEventHandler, ProjectExtractor projectExtractor, SearchCriteriaService searchCriteriaService) {
        this.activityEventHandler = activityEventHandler;
        this.projectExtractor = projectExtractor;
        this.searchCriteriaService = searchCriteriaService;
    }

    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    @PostMapping(value={"/searches"})
    @Operation(summary="Get activities by search criteria")
    public PagedResponse<ActivityEventResource> getActivities(@RequestParam @Min(value=0L) @Max(value=300L) @Min(value=0L) @Max(value=300L) int limit, @RequestParam @Min(value=0L) @Min(value=0L) int offset, @RequestParam Sort.Direction order, @RequestParam String sort, @RequestBody SearchCriteriaRQ searchCriteria, @AuthenticationPrincipal ReportPortalUser user) {
        Queryable filter = this.searchCriteriaService.createFilterBySearchCriteria(searchCriteria, Activity.class, PredefinedFilterType.ACTIVITIES);
        PageRequest pageable = PageRequest.of((int)(offset / limit), (int)limit, (Sort)Sort.by((Sort.Direction)order, (String[])new String[]{sort}));
        return this.activityEventHandler.getActivityEventsHistory(filter, (Pageable)pageable);
    }

    @GetMapping(value={"/{projectName}/subjectName"})
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    @Operation(summary="Load project activities subjectNames by filter", description="Only for current project")
    public List<String> getProjectSubjectName(@PathVariable String projectName, @RequestParam(value="filter.cnt.subjectName") String value, @AuthenticationPrincipal ReportPortalUser user) {
        return this.activityEventHandler.getSubjectNames(this.projectExtractor.extractProjectDetails(user, projectName), value);
    }
}

