/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller;

import com.epam.reportportal.model.ActivityResource;
import com.epam.reportportal.rules.exception.ErrorRS;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.core.activity.ActivityHandler;
import com.epam.ta.reportportal.entity.activity.Activity;
import com.epam.ta.reportportal.model.ActivityEventResource;
import com.epam.ta.reportportal.model.Page;
import com.epam.ta.reportportal.util.ProjectExtractor;
import com.epam.ta.reportportal.ws.resolver.FilterFor;
import com.epam.ta.reportportal.ws.resolver.SortFor;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/{projectName}/activity"})
@Transactional(readOnly=true)
@PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
@Tag(name="Activity", description="Activities API collection")
public class ActivityController {
    private final ActivityHandler activityHandler;
    private final ProjectExtractor projectExtractor;

    @Autowired
    public ActivityController(ActivityHandler activityHandler, ProjectExtractor projectExtractor) {
        this.activityHandler = activityHandler;
        this.projectExtractor = projectExtractor;
    }

    @RequestMapping(value={"/{activityId}"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get an activity by its ID in a specific project", description="Fetches the activity details by its ID for a specific project.", responses={@ApiResponse(responseCode="200", description="Successful operation. Returns the Activity", content={@Content(schema=@Schema(implementation=ActivityResource.class), examples={@ExampleObject(name="Successful operation", value="{\n      \"id\": 1,\n      \"user\": \"superadmin\",\n      \"loggedObjectId\": 22,\n      \"lastModified\": \"2024-03-29T15:03:54.156904Z\",\n      \"actionType\": \"finishLaunch\",\n      \"objectType\": \"LAUNCH\",\n      \"projectId\": 1,\n      \"details\": {\n          \"history\": []\n      },\n      \"objectName\": \"1 step (failed) - filled description\"\n}\n")})}), @ApiResponse(responseCode="400", description="Bad request", content={@Content(schema=@Schema(implementation=ErrorRS.class), examples={@ExampleObject(name="Bad request", value="{\n    \"timestamp\": \"2024-05-20T07:12:15.698+00:00\",\n    \"status\": 400,\n    \"error\": \"Bad Request\",\n    \"path\": \"/v1/superadmin_personal/activity/1test\"\n}\n")})}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorRS.class), examples={@ExampleObject(name="Unauthorized", value="{\n    \"error\": \"unauthorized\",\n    \"error_description\": \"Full authentication is required to access this resource.\"\n}\n")})}), @ApiResponse(responseCode="403", description="Access Denied", content={@Content(schema=@Schema(implementation=ErrorRS.class), examples={@ExampleObject(name="Access Denied", value="{\n    \"error\": \"access_denied\",\n    \"error_description\": \"You do not have enough permissions\"\n}\n")})}), @ApiResponse(responseCode="404", description="Activity not found", content={@Content(schema=@Schema(implementation=ErrorRS.class), examples={@ExampleObject(name="Activity not found", value="{\n    \"errorCode\": 40411,\n    \"message\": \"Activity '1' not found. Did you use correct Activity ID?\"\n}\n")})}), @ApiResponse(responseCode="500", description="Internal server error", content={@Content(schema=@Schema(implementation=ErrorRS.class), examples={@ExampleObject(name="Unclassified error", value="{\n    \"errorCode\": 5000,\n    \"message\": \"Unclassified error\"\n}\n")})})})
    public ActivityResource getActivity(@PathVariable @Parameter(description="The name of the project for which the activity should be searched") String projectName, @PathVariable @Parameter(description="The ID of the activity to be searched") Long activityId, @AuthenticationPrincipal ReportPortalUser user) {
        ReportPortalUser.ProjectDetails projectDetails = this.projectExtractor.extractProjectDetailsAdmin(user, EntityUtils.normalizeId((String)projectName));
        return this.activityHandler.getActivity(projectDetails, activityId);
    }

    @RequestMapping(value={"/item/{itemId}"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get a list of item activities for a specific project", description="Fetches a list of item activities for a specific project.\n<p>Action field can have these values:</p>\n<ul>\n<li>'create'</li>\n<li>'update'</li>\n<li>'delete'</li>\n<li>'bulkCreate'</li>\n<li>'bulkUpdate'</li>\n<li>'bulkDelete'</li>\n<li>'analyze'</li>\n<li>'start'</li>\n<li>'finish'</li>\n<li>'post'</li>\n<li>'link'</li>\n<li>'unlink'</li>\n<li>'assign'</li>\n<li>'unassign'</li>\n<li>'generate'</li>\n<li>'match'</li>\n<li>'changeRole'</li>\n<li>'updateUserRole'</li>\n</ul>\n<p>Priority field can have these values:</p>\n<ul>\n<li>'critical'</li>\n<li>'high'</li>\n<li>'medium'</li>\n<li>'low'</li>\n<li>'info'</li>\n</ul>\n<p>Object type field can have these values:</p>\n<ul>\n<li>'launch'</li>\n<li>'dashboard'</li>\n<li>'defectType'</li>\n<li>'emailConfig'</li>\n<li>'filter'</li>\n<li>'import'</li>\n<li>'integration'</li>\n<li>'itemIssue'</li>\n<li>'project'</li>\n<li>'sharing'</li>\n<li>'user'</li>\n<li>'widget'</li>\n<li>'pattern'</li>\n<li>'index'</li>\n<li>'plugin'</li>\n<li>'invitationLink'</li>\n</ul>\n<p>Subject type field can have these values:</p>\n<ul>\n<li>'user'</li>\n<li>'application'</li>\n<li>'rule'</li>\n<li>'custom'</li>\n</ul>\n<p> You can filter by different operators:\n<ul>\n<li>eq (Equals condition)</li>\n<li>ne (Not equals condition)</li>\n<li>cnt (Contains condition)</li>\n<li>under</li>\n<li>level (Number of labels in path)</li>\n<li>ex (Exists condition)</li>\n<li>in (Accepts filter value as comma-separated list)</li>\n<li>ea (Equals any. Accepts filter value as comma-separated list)</li>\n<li>has (Accepts filter value as comma-separated list. Returns 'TRUE' of all\nprovided values exist in collection)</li>\n<li>any (Overlap condition between two arrays)</li>\n<li>gt (Greater than condition)</li>\n<li>gte (Greater than or Equals condition)</li>\n<li>lt (Lower than condition)</li>\n<li>lte (Lower than or Equals condition)</li>\n<li>btw (Between condition. Include boundaries. 'Between' condition applicable only for\npositive Numbers, Dates or specific TimeStamp values)</li>\n</ul>\n", responses={@ApiResponse(responseCode="200", description="Successful operation. Returns a list of activities.", content={@Content(schema=@Schema(implementation=Page.class), examples={@ExampleObject(name="Successful operation", value="{\n     \"content\": [\n         {\n             \"id\": 1,\n             \"created_at\": \"2024-03-29T12:29:54.772Z\",\n             \"event_name\": \"updateItem\",\n             \"object_id\": 1153,\n             \"object_name\": \"Step-1(A)\",\n             \"object_type\": \"itemIssue\",\n             \"project_id\": 1,\n             \"project_name\": \"superadmin_personal\",\n             \"subject_name\": \"superadmin\",\n             \"subject_type\": \"user\",\n             \"subject_id\": \"1\",\n             \"details\": {\n                 \"history\": [\n                     {\n                         \"field\": \"status\",\n                         \"oldValue\": \"SKIPPED\",\n                         \"newValue\": \"FAILED\"\n                     }\n                 ]\n             }\n         }\n     ],\n     \"page\": {\n         \"number\": 1,\n         \"size\": 20,\n         \"totalElements\": 1,\n         \"totalPages\": 1\n     }\n }\n")})}), @ApiResponse(responseCode="400", description="Bad request", content={@Content(schema=@Schema(implementation=ErrorRS.class), examples={@ExampleObject(name="Bad request", value="{\n    \"timestamp\": \"2024-05-20T07:03:53.007+00:00\",\n    \"status\": 400,\n    \"error\": \"Bad Request\",\n    \"path\": \"/v1/superadmin_personal/activity/item/1test\"\n}\n")})}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(implementation=ErrorRS.class), examples={@ExampleObject(name="Unauthorized", value="{\n    \"error\": \"unauthorized\",\n    \"error_description\": \"Full authentication is required to access this resource.\"\n}\n")})}), @ApiResponse(responseCode="403", description="Access Denied", content={@Content(schema=@Schema(implementation=ErrorRS.class), examples={@ExampleObject(name="Access Denied", value="{\n    \"error\": \"access_denied\",\n    \"error_description\": \"You do not have enough permissions\"\n}\n")})}), @ApiResponse(responseCode="404", description="Test item not found or Launch not found", content={@Content(schema=@Schema(implementation=ErrorRS.class), examples={@ExampleObject(name="Test item not found", value="{\n    \"errorCode\": 4043,\n    \"message\": \"Test Item '1' not found. Did you use correct Test Item ID?\"\n}\n")})}), @ApiResponse(responseCode="500", description="Internal server error", content={@Content(schema=@Schema(implementation=ErrorType.class), examples={@ExampleObject(name="Unclassified error", value="{\n    \"errorCode\": 5000,\n    \"message\": \"Unclassified error\"\n}\n")})})})
    public Page<ActivityEventResource> getTestItemActivities(@PathVariable @Parameter(description="The name of the project for which the activities should be searched") String projectName, @PathVariable @Parameter(description="The ID of the test item for which all its activities should be searched") Long itemId, @FilterFor(value=Activity.class) Filter filter, @SortFor(value=Activity.class) Pageable pageable, @AuthenticationPrincipal ReportPortalUser user) {
        ReportPortalUser.ProjectDetails projectDetails = this.projectExtractor.extractProjectDetailsAdmin(user, EntityUtils.normalizeId((String)projectName));
        return this.activityHandler.getItemActivities(projectDetails, itemId, filter, pageable);
    }
}

