/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.util;

import com.epam.ta.reportportal.entity.ItemAttribute;
import com.epam.ta.reportportal.entity.enums.LaunchModeEnum;
import com.epam.ta.reportportal.entity.enums.TestItemTypeEnum;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.ws.reporting.ItemAttributeResource;
import com.google.common.base.CharMatcher;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;

public class Predicates {
    private static final Set<TestItemTypeEnum> INDEXED_ITEM_TYPES = Set.of(TestItemTypeEnum.STEP, TestItemTypeEnum.BEFORE_METHOD, TestItemTypeEnum.AFTER_METHOD);
    public static final Predicate<TestItem> ITEM_CAN_BE_INDEXED = testItem -> testItem != null && INDEXED_ITEM_TYPES.contains(testItem.getType()) && testItem.getItemResults().getIssue() != null && testItem.getItemResults().getIssue().getIgnoreAnalyzer() == false;
    public static final Predicate<Launch> LAUNCH_CAN_BE_INDEXED = launch -> launch != null && LaunchModeEnum.DEFAULT.equals((Object)launch.getMode());
    public static final BiPredicate<ItemAttribute, ItemAttributeResource> ITEM_ATTRIBUTE_EQUIVALENCE = (attribute, resource) -> {
        boolean valueAndSystemEquivalence;
        boolean bl = valueAndSystemEquivalence = attribute.getValue().equals(resource.getValue()) && attribute.isSystem() == false;
        return Objects.isNull(attribute.getKey()) ? Objects.isNull(resource.getKey()) && valueAndSystemEquivalence : attribute.getKey().equals(resource.getKey()) && valueAndSystemEquivalence;
    };
    private static final String SPECIAL_CHARACTERS = "-/@#$%^&_+=()";
    public static final Predicate<String> SPECIAL_CHARS_ONLY = str -> CharMatcher.anyOf((CharSequence)SPECIAL_CHARACTERS).matchesAllOf((CharSequence)str);

    private Predicates() {
    }
}

