/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.util;

import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.reporting.SaveLogRQ;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Path;
import jakarta.validation.Validator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class ControllerUtils {
    public static MultipartFile findByFileName(String filename, MultiValuedMap<String, MultipartFile> files) {
        if (files.containsKey((Object)filename)) {
            MultipartFile multipartFile = (MultipartFile)files.get((Object)filename).stream().findFirst().get();
            files.get((Object)filename).remove(multipartFile);
            return multipartFile;
        }
        for (MultipartFile file : files.values()) {
            if (!filename.equals(file.getOriginalFilename())) continue;
            return file;
        }
        return null;
    }

    public static Long safeParseLong(String value) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"The provided parameter must be a number"});
        }
    }

    public static Integer safeParseInt(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"The provided parameter must be a number"});
        }
    }

    public static void validateSaveRQ(Validator validator, SaveLogRQ saveLogRQ) {
        Set constraintViolations = validator.validate((Object)saveLogRQ, new Class[0]);
        if (constraintViolations != null && !constraintViolations.isEmpty()) {
            StringBuilder messageBuilder = new StringBuilder();
            for (ConstraintViolation constraintViolation : constraintViolations) {
                messageBuilder.append("[");
                messageBuilder.append("Incorrect value in save log request '");
                messageBuilder.append(constraintViolation.getInvalidValue());
                messageBuilder.append("' in field '");
                Iterator iterator = constraintViolation.getPropertyPath().iterator();
                messageBuilder.append(iterator.hasNext() ? ((Path.Node)iterator.next()).getName() : "");
                messageBuilder.append("'.]");
            }
            throw new ReportPortalException(ErrorType.INCORRECT_REQUEST, new Object[]{messageBuilder.toString()});
        }
    }

    public static MultiValuedMap<String, MultipartFile> getUploadedFiles(HttpServletRequest request) {
        ArrayListValuedHashMap uploadedFiles = new ArrayListValuedHashMap();
        if (request instanceof MultipartHttpServletRequest) {
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
            MultiValueMap multiFileMap = multipartRequest.getMultiFileMap();
            for (List multipartFiles : multiFileMap.values()) {
                for (MultipartFile file : multipartFiles) {
                    uploadedFiles.put((Object)file.getOriginalFilename(), (Object)file);
                }
            }
        }
        return uploadedFiles;
    }
}

