/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.reporting.event;

import com.epam.reportportal.events.FinishItemRqEvent;
import com.epam.reportportal.events.FinishLaunchRqEvent;
import com.epam.reportportal.events.SaveLogRqEvent;
import com.epam.reportportal.events.StartChildItemRqEvent;
import com.epam.reportportal.events.StartLaunchRqEvent;
import com.epam.reportportal.events.StartRootItemRqEvent;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.launch.impl.StartLaunchHandlerImpl;
import com.epam.ta.reportportal.core.launch.util.LinkGenerator;
import com.epam.ta.reportportal.reporting.async.producer.ItemFinishProducer;
import com.epam.ta.reportportal.reporting.async.producer.ItemStartProducer;
import com.epam.ta.reportportal.reporting.async.producer.LaunchFinishProducer;
import com.epam.ta.reportportal.reporting.async.producer.LogProducer;
import com.epam.ta.reportportal.util.ProjectExtractor;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class EventBasedReporting {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventBasedReporting.class);
    private final StartLaunchHandlerImpl startLaunchHandler;
    private final LaunchFinishProducer finishLaunchHandler;
    private final ItemStartProducer startTestItemHandler;
    private final ItemFinishProducer finishTestItemHandler;
    private final LogProducer createLogHandler;
    private final ProjectExtractor projectExtractor;

    @EventListener
    public void handleStartLaunch(StartLaunchRqEvent startLaunchRqEvent) {
        ReportPortalUser user = this.extractUserPrincipal();
        ReportPortalUser.ProjectDetails projectDetails = this.projectExtractor.extractProjectDetails(user, startLaunchRqEvent.getProjectName());
        this.startLaunchHandler.startLaunch(user, projectDetails, startLaunchRqEvent.getStartLaunchRQ());
    }

    @EventListener
    public void handleFinishLaunch(FinishLaunchRqEvent finishLaunchRqEvent) {
        ReportPortalUser user = this.extractUserPrincipal();
        ReportPortalUser.ProjectDetails projectDetails = this.projectExtractor.extractProjectDetails(user, finishLaunchRqEvent.getProjectName());
        this.finishLaunchHandler.finishLaunch(finishLaunchRqEvent.getLaunchUuid(), finishLaunchRqEvent.getFinishExecutionRQ(), projectDetails, user, this.extractCurrentHttpRequest().map(LinkGenerator::composeBaseUrl).orElse(""));
    }

    @EventListener
    public void handleStartRootItem(StartRootItemRqEvent startRootItemRqEvent) {
        ReportPortalUser user = this.extractUserPrincipal();
        ReportPortalUser.ProjectDetails projectDetails = this.projectExtractor.extractProjectDetails(user, startRootItemRqEvent.getProjectName());
        this.startTestItemHandler.startRootItem(user, projectDetails, startRootItemRqEvent.getStartTestItemRQ());
    }

    @EventListener
    public void handleStartItem(StartChildItemRqEvent startChildItemRqEvent) {
        ReportPortalUser user = this.extractUserPrincipal();
        ReportPortalUser.ProjectDetails projectDetails = this.projectExtractor.extractProjectDetails(user, startChildItemRqEvent.getProjectName());
        this.startTestItemHandler.startChildItem(user, projectDetails, startChildItemRqEvent.getStartTestItemRQ(), startChildItemRqEvent.getParentUuid());
    }

    @EventListener
    public void handleFinishRootItem(FinishItemRqEvent finishItemRqEvent) {
        ReportPortalUser user = this.extractUserPrincipal();
        ReportPortalUser.ProjectDetails projectDetails = this.projectExtractor.extractProjectDetails(user, finishItemRqEvent.getProjectName());
        this.finishTestItemHandler.finishTestItem(user, projectDetails, finishItemRqEvent.getItemUuid(), finishItemRqEvent.getFinishTestItemRQ());
    }

    @EventListener
    public void handleLogCreation(SaveLogRqEvent saveLogRqEvent) {
        ReportPortalUser user = this.extractUserPrincipal();
        ReportPortalUser.ProjectDetails projectDetails = this.projectExtractor.extractProjectDetails(user, saveLogRqEvent.getProjectName());
        this.createLogHandler.createLog(saveLogRqEvent.getSaveLogRQ(), saveLogRqEvent.getFile(), projectDetails);
    }

    private Optional<HttpServletRequest> extractCurrentHttpRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes instanceof ServletRequestAttributes) {
            ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)requestAttributes;
            return Optional.of(servletRequestAttributes.getRequest());
        }
        log.debug("Not called in the context of an HTTP request");
        return Optional.empty();
    }

    private ReportPortalUser extractUserPrincipal() {
        return (ReportPortalUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
    }

    @Generated
    public EventBasedReporting(StartLaunchHandlerImpl startLaunchHandler, LaunchFinishProducer finishLaunchHandler, ItemStartProducer startTestItemHandler, ItemFinishProducer finishTestItemHandler, LogProducer createLogHandler, ProjectExtractor projectExtractor) {
        this.startLaunchHandler = startLaunchHandler;
        this.finishLaunchHandler = finishLaunchHandler;
        this.startTestItemHandler = startTestItemHandler;
        this.finishTestItemHandler = finishTestItemHandler;
        this.createLogHandler = createLogHandler;
        this.projectExtractor = projectExtractor;
    }
}

