/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.reporting.async.producer;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.launch.StartLaunchHandler;
import com.epam.ta.reportportal.core.launch.rerun.RerunHandler;
import com.epam.ta.reportportal.reporting.async.config.RequestType;
import com.epam.ta.reportportal.ws.reporting.StartLaunchRQ;
import com.epam.ta.reportportal.ws.reporting.StartLaunchRS;
import java.util.Map;
import java.util.UUID;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class LaunchStartProducer
implements StartLaunchHandler {
    private final AmqpTemplate amqpTemplate;
    private final RerunHandler rerunHandler;

    public LaunchStartProducer(@Qualifier(value="rabbitTemplate") AmqpTemplate amqpTemplate, RerunHandler rerunHandler) {
        this.amqpTemplate = amqpTemplate;
        this.rerunHandler = rerunHandler;
    }

    @Override
    public StartLaunchRS startLaunch(ReportPortalUser user, ReportPortalUser.ProjectDetails projectDetails, StartLaunchRQ request) {
        this.validateRoles(projectDetails, request);
        if (request.isRerun()) {
            request.setUuid(this.rerunHandler.getRerunLaunchUuid(request.getRerunOf(), request.getName(), projectDetails.getProjectId()));
        } else if (!StringUtils.hasText((String)request.getUuid())) {
            request.setUuid(UUID.randomUUID().toString());
        }
        this.amqpTemplate.convertAndSend("e.reporting", "", (Object)request, message -> {
            Map headers = message.getMessageProperties().getHeaders();
            headers.put("hash-on", request.getUuid());
            headers.put("requestType", RequestType.START_LAUNCH);
            headers.put("username", user.getUsername());
            headers.put("projectName", projectDetails.getProjectName());
            return message;
        });
        StartLaunchRS response = new StartLaunchRS();
        response.setId(request.getUuid());
        return response;
    }
}

