/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.reporting.async.producer;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.launch.FinishLaunchHandler;
import com.epam.ta.reportportal.core.launch.util.LinkGenerator;
import com.epam.ta.reportportal.model.launch.FinishLaunchRS;
import com.epam.ta.reportportal.reporting.async.config.RequestType;
import com.epam.ta.reportportal.ws.reporting.FinishExecutionRQ;
import java.util.Map;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class LaunchFinishProducer
implements FinishLaunchHandler {
    private final AmqpTemplate amqpTemplate;

    public LaunchFinishProducer(@Qualifier(value="rabbitTemplate") AmqpTemplate amqpTemplate) {
        this.amqpTemplate = amqpTemplate;
    }

    @Override
    public FinishLaunchRS finishLaunch(String launchId, FinishExecutionRQ request, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user, String baseUrl) {
        this.amqpTemplate.convertAndSend("e.reporting", "", (Object)request, message -> {
            Map headers = message.getMessageProperties().getHeaders();
            headers.put("hash-on", launchId);
            headers.put("requestType", RequestType.FINISH_LAUNCH);
            headers.put("username", user.getUsername());
            headers.put("projectName", projectDetails.getProjectName());
            headers.put("launchId", launchId);
            headers.put("baseUrl", baseUrl);
            return message;
        });
        FinishLaunchRS response = new FinishLaunchRS();
        response.setId(launchId);
        response.setLink(LinkGenerator.generateLaunchLink(baseUrl, projectDetails.getProjectName(), launchId));
        return response;
    }
}

