/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.reporting.async.producer;

import com.epam.reportportal.rules.commons.validation.Suppliers;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.item.FinishTestItemHandler;
import com.epam.ta.reportportal.reporting.async.config.RequestType;
import com.epam.ta.reportportal.ws.reporting.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.reporting.OperationCompletionRS;
import java.util.Map;
import java.util.Optional;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ItemFinishProducer
implements FinishTestItemHandler {
    private final AmqpTemplate amqpTemplate;

    public ItemFinishProducer(@Qualifier(value="rabbitTemplate") AmqpTemplate amqpTemplate) {
        this.amqpTemplate = amqpTemplate;
    }

    @Override
    public OperationCompletionRS finishTestItem(ReportPortalUser user, ReportPortalUser.ProjectDetails projectDetails, String testItemId, FinishTestItemRQ request) {
        String launchUuid = Optional.ofNullable(request.getLaunchUuid()).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Launch UUID should not be null or empty."}));
        this.amqpTemplate.convertAndSend("e.reporting", "", (Object)request, message -> {
            Map headers = message.getMessageProperties().getHeaders();
            headers.put("hash-on", launchUuid);
            headers.put("requestType", RequestType.FINISH_TEST);
            headers.put("username", user.getUsername());
            headers.put("projectName", projectDetails.getProjectName());
            headers.put("itemId", testItemId);
            return message;
        });
        return new OperationCompletionRS((String)Suppliers.formattedSupplier((String)"Accepted finish request for test item ID = {}", (Object[])new Object[]{testItemId}).get());
    }
}

