/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.reporting.async.message;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Validator;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.stereotype.Component;

@Component
public class MessageRetriever {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageRetriever.class);
    private final ObjectMapper objectMapper;
    private final Validator validator;

    public MessageRetriever(ObjectMapper objectMapper, Validator validator) {
        this.objectMapper = objectMapper;
        this.validator = validator;
    }

    public <T> Optional<T> retrieveValid(Message income, Class<T> type) {
        String incomeMessage = new String(income.getBody(), StandardCharsets.UTF_8);
        try {
            Object object = this.objectMapper.readValue(incomeMessage, type);
            Set violations = this.validator.validate(object, new Class[0]);
            if (violations.isEmpty()) {
                return Optional.of(object);
            }
            throw new ConstraintViolationException(violations);
        }
        catch (ConstraintViolationException e) {
            LOGGER.error("Incorrect incoming message. Message violations: {}", (Object)e.getMessage());
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Incorrect json format of incoming message. Discarded message: {}", (Object)incomeMessage);
        }
        return Optional.empty();
    }
}

