/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.reporting.async.controller;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.item.FinishTestItemHandler;
import com.epam.ta.reportportal.core.item.StartTestItemHandler;
import com.epam.ta.reportportal.core.logging.HttpLogging;
import com.epam.ta.reportportal.util.ProjectExtractor;
import com.epam.ta.reportportal.ws.reporting.EntryCreatedAsyncRS;
import com.epam.ta.reportportal.ws.reporting.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.reporting.OperationCompletionRS;
import com.epam.ta.reportportal.ws.reporting.StartTestItemRQ;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v2/{projectName}/item"})
@PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
@Tag(name="Test Item Async", description="Test Items Async API collection")
public class TestItemAsyncController {
    private final ProjectExtractor projectExtractor;
    private final StartTestItemHandler startTestItemHandler;
    private final FinishTestItemHandler finishTestItemHandler;

    @Autowired
    public TestItemAsyncController(ProjectExtractor projectExtractor, @Qualifier(value="itemStartProducer") StartTestItemHandler startTestItemHandler, @Qualifier(value="itemFinishProducer") FinishTestItemHandler finishTestItemHandler) {
        this.projectExtractor = projectExtractor;
        this.startTestItemHandler = startTestItemHandler;
        this.finishTestItemHandler = finishTestItemHandler;
    }

    @HttpLogging
    @PostMapping(value={"", "/"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @Operation(description="Start a root test item")
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')||hasRole('ADMINISTRATOR')")
    public EntryCreatedAsyncRS startRootItem(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @RequestBody @Validated StartTestItemRQ startTestItemRQ) {
        return this.startTestItemHandler.startRootItem(user, this.projectExtractor.extractProjectDetails(user, projectName), startTestItemRQ);
    }

    @HttpLogging
    @PostMapping(value={"/{parentItem}", "/{parentItem}/"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @Operation(description="Start a child test item")
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')||hasRole('ADMINISTRATOR')")
    public EntryCreatedAsyncRS startChildItem(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @PathVariable String parentItem, @RequestBody @Validated StartTestItemRQ startTestItemRQ) {
        return this.startTestItemHandler.startChildItem(user, this.projectExtractor.extractProjectDetails(user, projectName), startTestItemRQ, parentItem);
    }

    @HttpLogging
    @PutMapping(value={"/{testItemId}", "/{testItemId}/"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(description="Finish test item")
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')||hasRole('ADMINISTRATOR')")
    public OperationCompletionRS finishTestItem(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @PathVariable String testItemId, @RequestBody @Validated FinishTestItemRQ finishExecutionRQ) {
        return this.finishTestItemHandler.finishTestItem(user, this.projectExtractor.extractProjectDetails(user, projectName), testItemId, finishExecutionRQ);
    }
}

