/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.reporting.async.controller;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.commons.validation.Suppliers;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.log.CreateLogHandler;
import com.epam.ta.reportportal.core.logging.HttpLogging;
import com.epam.ta.reportportal.util.ControllerUtils;
import com.epam.ta.reportportal.util.ProjectExtractor;
import com.epam.ta.reportportal.ws.reporting.BatchElementCreatedRS;
import com.epam.ta.reportportal.ws.reporting.BatchSaveOperatingRS;
import com.epam.ta.reportportal.ws.reporting.EntryCreatedAsyncRS;
import com.epam.ta.reportportal.ws.reporting.SaveLogRQ;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Validator;
import java.util.function.Predicate;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/v2/{projectName}/log"})
@PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
@Tag(name="Log Async", description="Logs Async API collection")
public class LogAsyncController {
    private final ProjectExtractor projectExtractor;
    private final CreateLogHandler createLogHandler;
    private final Validator validator;

    @Autowired
    public LogAsyncController(ProjectExtractor projectExtractor, @Qualifier(value="logProducer") CreateLogHandler createLogHandler, Validator validator) {
        this.projectExtractor = projectExtractor;
        this.createLogHandler = createLogHandler;
        this.validator = validator;
    }

    @Deprecated
    @HttpLogging
    @PostMapping(consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @Hidden
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')||hasRole('ADMINISTRATOR')")
    public EntryCreatedAsyncRS createLog(@PathVariable String projectName, @RequestBody SaveLogRQ createLogRQ, @AuthenticationPrincipal ReportPortalUser user) {
        ControllerUtils.validateSaveRQ(this.validator, createLogRQ);
        return this.createLogHandler.createLog(createLogRQ, null, this.projectExtractor.extractProjectDetails(user, projectName));
    }

    @HttpLogging
    @PostMapping(value={"/entry"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @Operation(description="Create log")
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')||hasRole('ADMINISTRATOR')")
    public EntryCreatedAsyncRS createLogEntry(@PathVariable String projectName, @RequestBody SaveLogRQ createLogRQ, @AuthenticationPrincipal ReportPortalUser user) {
        ControllerUtils.validateSaveRQ(this.validator, createLogRQ);
        return this.createLogHandler.createLog(createLogRQ, null, this.projectExtractor.extractProjectDetails(user, projectName));
    }

    @HttpLogging
    @PostMapping(consumes={"multipart/form-data"})
    @Operation(description="Create log (batching operation)")
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')||hasRole('ADMINISTRATOR')")
    public ResponseEntity<BatchSaveOperatingRS> createLog(@PathVariable String projectName, @RequestPart(value="json_request_part") SaveLogRQ[] createLogRQs, HttpServletRequest request, @AuthenticationPrincipal ReportPortalUser user) {
        MultiValuedMap<String, MultipartFile> uploadedFiles = ControllerUtils.getUploadedFiles(request);
        BatchSaveOperatingRS response = new BatchSaveOperatingRS();
        for (SaveLogRQ createLogRq : createLogRQs) {
            try {
                EntryCreatedAsyncRS responseItem;
                String filename;
                ControllerUtils.validateSaveRQ(this.validator, createLogRq);
                String string = filename = createLogRq.getFile() == null ? null : createLogRq.getFile().getName();
                if (StringUtils.isEmpty((CharSequence)filename)) {
                    responseItem = this.createLog(projectName, createLogRq, user);
                } else {
                    MultipartFile data = ControllerUtils.findByFileName(filename, uploadedFiles);
                    BusinessRule.expect((Object)data, (Predicate)Predicates.notNull()).verify(ErrorType.BINARY_DATA_CANNOT_BE_SAVED, new Object[]{Suppliers.formattedSupplier((String)"There is no request part or file with name {}", (Object[])new Object[]{filename})});
                    responseItem = this.createLogHandler.createLog(createLogRq, data, this.projectExtractor.extractProjectDetails(user, projectName));
                }
                response.addResponse(new BatchElementCreatedRS(responseItem.getId()));
            }
            catch (Exception e) {
                response.addResponse(new BatchElementCreatedRS(ExceptionUtils.getStackTrace((Throwable)e), ExceptionUtils.getMessage((Throwable)e)));
            }
        }
        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
    }
}

