/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.reporting.async.controller;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.launch.FinishLaunchHandler;
import com.epam.ta.reportportal.core.launch.MergeLaunchHandler;
import com.epam.ta.reportportal.core.launch.StartLaunchHandler;
import com.epam.ta.reportportal.core.launch.util.LinkGenerator;
import com.epam.ta.reportportal.core.logging.HttpLogging;
import com.epam.ta.reportportal.model.launch.FinishLaunchRS;
import com.epam.ta.reportportal.util.ProjectExtractor;
import com.epam.ta.reportportal.ws.converter.converters.LaunchConverter;
import com.epam.ta.reportportal.ws.reporting.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.reporting.LaunchResource;
import com.epam.ta.reportportal.ws.reporting.LaunchResourceOld;
import com.epam.ta.reportportal.ws.reporting.MergeLaunchesRQ;
import com.epam.ta.reportportal.ws.reporting.StartLaunchRQ;
import com.epam.ta.reportportal.ws.reporting.StartLaunchRS;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v2/{projectName}/launch"})
@Tag(name="Launch Async", description="Launches Async API collection")
public class LaunchAsyncController {
    private final ProjectExtractor projectExtractor;
    private final StartLaunchHandler startLaunchHandler;
    private final FinishLaunchHandler finishLaunchHandler;
    private final MergeLaunchHandler mergeLaunchesHandler;
    private final LaunchConverter launchConverter;

    @Autowired
    public LaunchAsyncController(ProjectExtractor projectExtractor, @Qualifier(value="launchStartProducer") StartLaunchHandler startLaunchHandler, @Qualifier(value="launchFinishProducer") FinishLaunchHandler finishLaunchHandler, MergeLaunchHandler mergeLaunchesHandler, LaunchConverter launchConverter) {
        this.projectExtractor = projectExtractor;
        this.startLaunchHandler = startLaunchHandler;
        this.finishLaunchHandler = finishLaunchHandler;
        this.mergeLaunchesHandler = mergeLaunchesHandler;
        this.launchConverter = launchConverter;
    }

    @HttpLogging
    @PostMapping
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')||hasRole('ADMINISTRATOR')")
    @ResponseStatus(value=HttpStatus.CREATED)
    @Operation(summary="Starts launch for specified project")
    public StartLaunchRS startLaunch(@PathVariable String projectName, @Parameter(description="Start launch request body", required=true) @RequestBody @Validated StartLaunchRQ startLaunchRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.startLaunchHandler.startLaunch(user, this.projectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), startLaunchRQ);
    }

    @HttpLogging
    @PutMapping(value={"/{launchId}/finish"})
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')||hasRole('ADMINISTRATOR')")
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(description="Finish launch for specified project")
    public FinishLaunchRS finishLaunch(@PathVariable String projectName, @PathVariable String launchId, @RequestBody @Validated FinishExecutionRQ finishLaunchRQ, @AuthenticationPrincipal ReportPortalUser user, HttpServletRequest request) {
        return this.finishLaunchHandler.finishLaunch(launchId, finishLaunchRQ, this.projectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), user, LinkGenerator.composeBaseUrl(request));
    }

    @HttpLogging
    @Transactional
    @PostMapping(value={"/merge"}, produces={"application/x.reportportal.launch.v2+json"})
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')||hasRole('ADMINISTRATOR')")
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Merge set of specified launches in common one", description="This operation merges a set of launches into a common one. The IDs of the launches to be merged should be provided in the 'launches' field of the request body.")
    public LaunchResource mergeLaunches(@PathVariable String projectName, @Parameter(description="Merge launches request body", required=true) @RequestBody @Validated MergeLaunchesRQ mergeLaunchesRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.mergeLaunchesHandler.mergeLaunches(this.projectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), user, mergeLaunchesRQ);
    }

    @HttpLogging
    @Transactional
    @PostMapping(value={"/merge"})
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')||hasRole('ADMINISTRATOR')")
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Merge set of specified launches in common one", description="This operation merges a set of launches into a common one. The IDs of the launches to be merged should be provided in the 'launches' field of the request body.")
    @ApiResponse(responseCode="200", description="Successful response with dates in timestamp format. Response with dates in ISO-8601 format if the custom header 'Accept: application/x.reportportal.launch.v2+json' is used.", content={@Content(mediaType="application/json", schema=@Schema(implementation=LaunchResourceOld.class))})
    public LaunchResourceOld mergeLaunchesOldUuid(@PathVariable String projectName, @Parameter(description="Merge launches request body", required=true) @RequestBody @Validated MergeLaunchesRQ mergeLaunchesRQ, @AuthenticationPrincipal ReportPortalUser user) {
        LaunchResource launchResource = this.mergeLaunchesHandler.mergeLaunches(this.projectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), user, mergeLaunchesRQ);
        return this.launchConverter.TO_RESOURCE_OLD.apply(launchResource);
    }
}

