/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.reporting.async.config;

import com.epam.ta.reportportal.reporting.async.consumer.ReportingConsumer;
import com.epam.ta.reportportal.reporting.async.exception.ReportingErrorHandler;
import com.epam.ta.reportportal.reporting.async.handler.provider.ReportingHandlerProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.CustomExchange;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.QueueBuilder;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.listener.AbstractMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ErrorHandler;

@Configuration
public class ReportingTopologyConfiguration {
    public static final String REPORTING_EXCHANGE = "e.reporting";
    public static final String RETRY_EXCHANGE = "e.reporting.retry";
    public static final String DEFAULT_CONSISTENT_HASH_ROUTING_KEY = "";
    public static final String DEFAULT_QUEUE_ROUTING_KEY = "1";
    public static final String REPORTING_QUEUE_PREFIX = "q.reporting.";
    public static final String TTL_QUEUE_MS = "q.retry.reporting.ttl.ms";
    public static final String TTL_QUEUE_S = "q.retry.reporting.ttl.s";
    public static final String TTL_QUEUE_M = "q.retry.reporting.ttl.m";
    public static final String REPORTING_PARKING_LOT = "q.parkingLot.reporting";
    private final AmqpAdmin amqpAdmin;
    @Value(value="${reporting.parkingLot.ttl.days:7}")
    private long parkingLotTtl;
    @Value(value="${reporting.queues.count:10}")
    private Integer queuesCount;
    @Value(value="${reporting.consumer.prefetchCount:10}")
    private Integer prefetchCount;

    @Bean
    String instanceUniqueId() {
        String instanceId = UUID.randomUUID().toString();
        return instanceId.substring(instanceId.lastIndexOf("-") + 1);
    }

    @Bean
    Exchange reportingConsistentExchange() {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("hash-header", "hash-on");
        return new CustomExchange(REPORTING_EXCHANGE, "x-consistent-hash", true, false, args);
    }

    @Bean(value={"reportingQueues"})
    List<Queue> reportingQueues() {
        ArrayList<Queue> queues = new ArrayList<Queue>(this.queuesCount);
        for (int i = 0; i < this.queuesCount; ++i) {
            String queueName = REPORTING_QUEUE_PREFIX + this.instanceUniqueId() + "." + i;
            Queue queue = this.buildQueue(queueName);
            queues.add(queue);
        }
        return queues;
    }

    @Bean(value={"reportingBindings"})
    List<Binding> reportingBindings(@Qualifier(value="reportingQueues") List<Queue> queues) {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        for (Queue queue : queues) {
            Binding queueBinding = this.buildQueueBinding(queue);
            this.amqpAdmin.declareBinding(queueBinding);
            bindings.add(queueBinding);
        }
        return bindings;
    }

    @Bean
    DirectExchange retryExchange() {
        return new DirectExchange(RETRY_EXCHANGE);
    }

    @Bean
    Queue ttlQueueMs() {
        return QueueBuilder.durable((String)TTL_QUEUE_MS).ttl(500).deadLetterExchange(REPORTING_EXCHANGE).deadLetterRoutingKey(DEFAULT_CONSISTENT_HASH_ROUTING_KEY).build();
    }

    @Bean
    Binding ttlQueueMsBinding() {
        return BindingBuilder.bind((Queue)this.ttlQueueMs()).to(this.retryExchange()).with(TTL_QUEUE_MS);
    }

    @Bean
    Queue ttlQueueS() {
        return QueueBuilder.durable((String)TTL_QUEUE_S).ttl(5000).deadLetterExchange(REPORTING_EXCHANGE).deadLetterRoutingKey(DEFAULT_CONSISTENT_HASH_ROUTING_KEY).build();
    }

    @Bean
    Binding ttlQueueSBinding() {
        return BindingBuilder.bind((Queue)this.ttlQueueS()).to(this.retryExchange()).with(TTL_QUEUE_S);
    }

    @Bean
    Queue ttlQueueM() {
        return QueueBuilder.durable((String)TTL_QUEUE_M).ttl(120000).deadLetterExchange(REPORTING_EXCHANGE).deadLetterRoutingKey(DEFAULT_CONSISTENT_HASH_ROUTING_KEY).build();
    }

    @Bean
    Binding ttlQueueMBinding() {
        return BindingBuilder.bind((Queue)this.ttlQueueM()).to(this.retryExchange()).with(TTL_QUEUE_M);
    }

    @Bean
    public Queue reportingParkingLot() {
        return QueueBuilder.durable((String)REPORTING_PARKING_LOT).ttl((int)TimeUnit.DAYS.toMillis(this.parkingLotTtl)).build();
    }

    private Binding buildQueueBinding(Queue queue) {
        Binding queueBinding = BindingBuilder.bind((Queue)queue).to(this.reportingConsistentExchange()).with(DEFAULT_QUEUE_ROUTING_KEY).noargs();
        queueBinding.setShouldDeclare(true);
        queueBinding.setAdminsThatShouldDeclare(new Object[]{this.amqpAdmin});
        return queueBinding;
    }

    private Queue buildQueue(String queueName) {
        Queue queue = QueueBuilder.durable((String)queueName).build();
        queue.setShouldDeclare(true);
        queue.setAdminsThatShouldDeclare(new Object[]{this.amqpAdmin});
        this.amqpAdmin.declareQueue(queue);
        return queue;
    }

    @Bean(value={"listenerContainers"})
    public List<AbstractMessageListenerContainer> listenerContainers(ConnectionFactory connectionFactory, ApplicationEventPublisher applicationEventPublisher, ReportingHandlerProvider reportingHandlerProvider, ReportingErrorHandler errorHandler, @Qualifier(value="reportingQueues") List<Queue> queues) {
        ArrayList<AbstractMessageListenerContainer> containers = new ArrayList<AbstractMessageListenerContainer>();
        queues.forEach(q -> {
            SimpleMessageListenerContainer listenerContainer = new SimpleMessageListenerContainer(connectionFactory);
            containers.add((AbstractMessageListenerContainer)listenerContainer);
            listenerContainer.setConnectionFactory(connectionFactory);
            listenerContainer.addQueueNames(new String[]{q.getName()});
            listenerContainer.setErrorHandler((ErrorHandler)errorHandler);
            listenerContainer.setExclusive(true);
            listenerContainer.setPrefetchCount(this.prefetchCount.intValue());
            listenerContainer.setDefaultRequeueRejected(false);
            listenerContainer.setMissingQueuesFatal(true);
            listenerContainer.setApplicationEventPublisher(applicationEventPublisher);
            listenerContainer.setupMessageListener(this.reportingListener(reportingHandlerProvider));
            listenerContainer.afterPropertiesSet();
            listenerContainer.start();
            containers.add((AbstractMessageListenerContainer)listenerContainer);
        });
        return containers;
    }

    @Bean
    public MessageListener reportingListener(ReportingHandlerProvider reportingHandlerProvider) {
        return new ReportingConsumer(reportingHandlerProvider);
    }

    @Generated
    public ReportingTopologyConfiguration(AmqpAdmin amqpAdmin) {
        this.amqpAdmin = amqpAdmin;
    }
}

