/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.reporting.async;

import com.rabbitmq.http.client.Client;
import com.rabbitmq.http.client.domain.QueueInfo;
import com.rabbitmq.http.client.domain.ShovelDetails;
import com.rabbitmq.http.client.domain.ShovelInfo;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.amqp.core.Queue;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class OutdatedQueuesManagementJob {
    private final Client managementClient;
    private final List<String> queues;
    private final String address;
    private final String vhost;

    public OutdatedQueuesManagementJob(Client managementClient, @Qualifier(value="reportingQueues") List<Queue> currentReportingQueues, @Value(value="${rp.amqp.addresses}") String address, @Value(value="${rp.amqp.base-vhost}") String virtualHost) {
        this.managementClient = managementClient;
        this.queues = currentReportingQueues.stream().map(Queue::getName).collect(Collectors.toList());
        this.address = address;
        this.vhost = virtualHost;
    }

    @Scheduled(fixedDelay=300000L, initialDelay=60000L)
    public void run() {
        List<QueueInfo> idleQueues = this.getIdleQueues();
        idleQueues.forEach(q -> this.managementClient.unbindQueue(q.getVhost(), q.getName(), "e.reporting", "1"));
        idleQueues.forEach(q -> {
            if (q.getMessagesReady() > 0L) {
                ShovelDetails shovelDetails = new ShovelDetails(this.address, this.address, 60L, false, null);
                shovelDetails.setSourceQueue(q.getName());
                shovelDetails.setSourceDeleteAfter("queue-length");
                shovelDetails.setDestinationExchange("e.reporting");
                ShovelInfo shovelInfo = new ShovelInfo(q.getName(), shovelDetails);
                this.managementClient.declareShovel(this.vhost, shovelInfo);
            } else {
                this.managementClient.deleteQueue(this.vhost, q.getName());
                this.managementClient.deleteShovel(this.vhost, q.getName());
            }
        });
    }

    private List<QueueInfo> getIdleQueues() {
        return this.managementClient.getQueues().stream().filter(q -> !this.queues.contains(q.getName()) && q.getName().startsWith("q.reporting.") && q.getConsumerCount() == 0L).collect(Collectors.toList());
    }
}

