/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.plugin;

import com.epam.reportportal.extension.ReportPortalExtensionPoint;
import com.epam.reportportal.extension.common.IntegrationTypeProperties;
import com.epam.reportportal.extension.event.PluginEvent;
import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.commons.validation.Suppliers;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.core.integration.plugin.PluginLoader;
import com.epam.ta.reportportal.core.plugin.Pf4jPluginBox;
import com.epam.ta.reportportal.core.plugin.Plugin;
import com.epam.ta.reportportal.core.plugin.PluginInfo;
import com.epam.ta.reportportal.dao.IntegrationTypeRepository;
import com.epam.ta.reportportal.entity.enums.IntegrationGroupEnum;
import com.epam.ta.reportportal.entity.enums.PluginTypeEnum;
import com.epam.ta.reportportal.entity.integration.IntegrationType;
import com.epam.ta.reportportal.entity.integration.IntegrationTypeDetails;
import com.epam.ta.reportportal.entity.plugin.PluginFileExtension;
import com.epam.ta.reportportal.ws.converter.builders.IntegrationTypeBuilder;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.pf4j.ExtensionPoint;
import org.pf4j.PluginManager;
import org.pf4j.PluginRuntimeException;
import org.pf4j.PluginState;
import org.pf4j.PluginWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class Pf4jPluginManager
implements Pf4jPluginBox {
    public static final Logger LOGGER = LoggerFactory.getLogger(Pf4jPluginManager.class);
    public static final String LOAD_KEY = "load";
    public static final String UNLOAD_KEY = "unload";
    private static final long MAXIMUM_UPLOADED_PLUGINS = 50L;
    private static final long PLUGIN_LIVE_TIME = 2L;
    private final String pluginsDir;
    private final String pluginsTempDir;
    private final String resourcesDir;
    private final Cache<String, Path> uploadingPlugins;
    private final PluginLoader pluginLoader;
    private final IntegrationTypeRepository integrationTypeRepository;
    private final PluginManager pluginManager;
    private final AutowireCapableBeanFactory autowireCapableBeanFactory;
    private final ApplicationEventPublisher applicationEventPublisher;

    public Pf4jPluginManager(String pluginsDir, String pluginsTempPath, String resourcesDir, PluginLoader pluginLoader, IntegrationTypeRepository integrationTypeRepository, PluginManager pluginManager, AutowireCapableBeanFactory autowireCapableBeanFactory, ApplicationEventPublisher applicationEventPublisher) throws IOException {
        this.pluginsDir = pluginsDir;
        Files.createDirectories(Paths.get(this.pluginsDir, new String[0]), new FileAttribute[0]);
        this.resourcesDir = resourcesDir;
        Files.createDirectories(Paths.get(this.resourcesDir, new String[0]), new FileAttribute[0]);
        this.pluginsTempDir = pluginsTempPath;
        Files.createDirectories(Paths.get(this.pluginsTempDir, new String[0]), new FileAttribute[0]);
        this.autowireCapableBeanFactory = autowireCapableBeanFactory;
        this.applicationEventPublisher = applicationEventPublisher;
        this.pluginLoader = pluginLoader;
        this.integrationTypeRepository = integrationTypeRepository;
        this.uploadingPlugins = CacheBuilder.newBuilder().maximumSize(50L).expireAfterWrite(2L, TimeUnit.MINUTES).build();
        this.pluginManager = pluginManager;
    }

    @Override
    public List<Plugin> getPlugins() {
        return this.pluginManager.getPlugins().stream().flatMap(plugin -> this.pluginManager.getExtensionClasses(plugin.getPluginId()).stream().map(com.epam.reportportal.extension.common.ExtensionPoint::findByExtension).filter(Optional::isPresent).map(it -> new Plugin(plugin.getPluginId(), (com.epam.reportportal.extension.common.ExtensionPoint)it.get()))).collect(Collectors.toList());
    }

    @Override
    public Optional<Plugin> getPlugin(String type) {
        return this.getPlugins().stream().filter(p -> p.getType().name().equalsIgnoreCase(type)).findAny();
    }

    @Override
    public <T> Optional<T> getInstance(String name, Class<T> extension) {
        return this.pluginManager.getExtensions(extension, name).stream().findFirst();
    }

    @Override
    public <T> Optional<T> getInstance(Class<T> extension) {
        return this.pluginManager.getExtensions(extension).stream().findFirst();
    }

    @Override
    public void startUp() {
        this.integrationTypeRepository.findAll().stream().filter(IntegrationType::isEnabled).filter(it -> it.getPluginType() == PluginTypeEnum.EXTENSION).forEach(integrationType -> Optional.ofNullable(integrationType.getDetails()).ifPresent(integrationTypeDetails -> {
            try {
                this.loadPlugin(integrationType.getName(), (IntegrationTypeDetails)integrationTypeDetails);
            }
            catch (Exception ex) {
                LOGGER.error("Unable to load plugin '{}'", (Object)integrationType.getName());
            }
        }));
    }

    @Override
    public void shutDown() {
        this.pluginManager.stopPlugins();
        this.pluginManager.getPlugins().forEach(p -> this.pluginManager.unloadPlugin(p.getPluginId()));
    }

    @Override
    public PluginState startUpPlugin(String pluginId) {
        PluginWrapper pluginWrapper = Optional.ofNullable(this.pluginManager.getPlugin(pluginId)).orElseThrow(() -> new ReportPortalException(ErrorType.UNABLE_INTERACT_WITH_INTEGRATION, new Object[]{"Plugin not found: " + pluginId}));
        return this.pluginManager.startPlugin(pluginWrapper.getPluginId());
    }

    @Override
    public boolean loadPlugin(String pluginId, IntegrationTypeDetails integrationTypeDetails) {
        return Optional.ofNullable(integrationTypeDetails.getDetails()).map(details -> {
            String fileName = IntegrationTypeProperties.FILE_NAME.getValue(details).map(String::valueOf).orElseThrow(() -> new ReportPortalException(ErrorType.PLUGIN_UPLOAD_ERROR, new Object[]{Suppliers.formattedSupplier((String)"'File name' property of the plugin - '{}' is not specified", (Object[])new Object[]{pluginId}).get()}));
            Path pluginPath = Paths.get(this.pluginsDir, fileName);
            if (Files.notExists(pluginPath, new LinkOption[0])) {
                String fileId = IntegrationTypeProperties.FILE_ID.getValue(details).map(String::valueOf).orElseThrow(() -> new ReportPortalException(ErrorType.PLUGIN_UPLOAD_ERROR, new Object[]{Suppliers.formattedSupplier((String)"'File id' property of the plugin - '{}' is not specified", (Object[])new Object[]{pluginId}).get()}));
                try {
                    this.pluginLoader.copyFromDataStore(fileId, pluginPath, Paths.get(this.resourcesDir, pluginId));
                }
                catch (IOException e) {
                    throw new ReportPortalException(ErrorType.PLUGIN_UPLOAD_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Unable to load plugin - '{}' from the data store", (Object[])new Object[]{pluginId}).get()});
                }
            } else {
                this.copyPluginResources(pluginPath, pluginId);
            }
            return Optional.ofNullable(this.pluginManager.loadPlugin(pluginPath)).map(id -> {
                if (PluginState.STARTED == this.pluginManager.startPlugin(pluginId)) {
                    this.initPlugin(pluginId);
                    this.applicationEventPublisher.publishEvent((ApplicationEvent)new PluginEvent(pluginId, LOAD_KEY));
                    return true;
                }
                return false;
            }).orElse(Boolean.FALSE);
        }).orElse(Boolean.FALSE);
    }

    private void initPlugin(String pluginId) {
        try {
            Optional<ExtensionPoint> extensionPoint = this.getInstance(pluginId, ExtensionPoint.class);
            extensionPoint.ifPresent(extension -> LOGGER.info((String)Suppliers.formattedSupplier((String)"Plugin - '{}' initialized.", (Object[])new Object[]{pluginId}).get()));
        }
        catch (NoClassDefFoundError error) {
            LOGGER.warn("Can't init plugin {}. Error {}. Please, try to load a new version of plugin", (Object)pluginId, (Object)error.getMessage());
        }
    }

    private void copyPluginResources(Path pluginPath, String pluginId) {
        try {
            this.pluginLoader.copyPluginResource(pluginPath, Paths.get(this.resourcesDir, pluginId));
        }
        catch (IOException e) {
            throw new ReportPortalException(ErrorType.PLUGIN_UPLOAD_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Unable to load resources of the - '{}' plugin", (Object[])new Object[]{pluginId}).get()});
        }
    }

    @Override
    public boolean unloadPlugin(IntegrationType integrationType) {
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new PluginEvent(integrationType.getName(), UNLOAD_KEY));
        this.destroyDependency(integrationType.getName());
        return this.pluginManager.unloadPlugin(integrationType.getName());
    }

    @Override
    public boolean deletePlugin(String pluginId) {
        return this.integrationTypeRepository.findByName(pluginId).map(this::deletePlugin).orElse(Boolean.TRUE);
    }

    @Override
    public boolean deletePlugin(PluginWrapper pluginWrapper) {
        return this.integrationTypeRepository.findByName(pluginWrapper.getPluginId()).map(this::deletePlugin).orElseGet(() -> {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new PluginEvent(pluginWrapper.getPluginId(), UNLOAD_KEY));
            this.deletePluginResources(Paths.get(this.resourcesDir, pluginWrapper.getPluginId()).toString());
            this.destroyDependency(pluginWrapper.getPluginId());
            return this.pluginManager.deletePlugin(pluginWrapper.getPluginId());
        });
    }

    private boolean deletePlugin(IntegrationType integrationType) {
        Optional<Map> pluginData = Optional.ofNullable(integrationType.getDetails()).map(IntegrationTypeDetails::getDetails);
        pluginData.ifPresent(this::deletePluginResources);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new PluginEvent(integrationType.getName(), UNLOAD_KEY));
        boolean pluginRemoved = Optional.ofNullable(this.pluginManager.getPlugin(integrationType.getName())).map(pluginWrapper -> {
            this.destroyDependency(pluginWrapper.getPluginId());
            if (integrationType.isEnabled()) {
                return this.pluginManager.deletePlugin(integrationType.getName());
            }
            return true;
        }).orElse(Boolean.TRUE);
        boolean pluginFileRemoved = pluginData.map(this::deletePluginFile).orElse(Boolean.TRUE);
        return pluginRemoved && pluginFileRemoved;
    }

    private void deletePluginResources(Map<String, Object> details) {
        IntegrationTypeProperties.RESOURCES_DIRECTORY.getValue(details).map(String::valueOf).ifPresent(this::deletePluginResources);
        IntegrationTypeProperties.FILE_ID.getValue(details).map(String::valueOf).ifPresent(this.pluginLoader::deleteFromDataStore);
    }

    private void deletePluginResources(String resourcesDir) {
        try {
            FileUtils.deleteDirectory((File)FileUtils.getFile((String[])new String[]{resourcesDir}));
        }
        catch (IOException e) {
            throw new ReportPortalException(ErrorType.PLUGIN_REMOVE_ERROR, new Object[]{"Unable to delete plugin resources."});
        }
    }

    private boolean deletePluginFile(Map<String, Object> details) {
        return IntegrationTypeProperties.FILE_NAME.getValue(details).map(String::valueOf).map(fileName -> Paths.get(this.pluginsDir, fileName)).map(path -> {
            try {
                if (Files.exists(path, new LinkOption[0])) {
                    return Files.deleteIfExists(path);
                }
                return true;
            }
            catch (IOException e) {
                throw new ReportPortalException(ErrorType.PLUGIN_REMOVE_ERROR, new Object[]{"Error during plugin file removing from the filesystem: " + e.getMessage()});
            }
        }).orElse(Boolean.TRUE);
    }

    @Override
    public Optional<PluginWrapper> getPluginById(String id) {
        return Optional.ofNullable(this.pluginManager.getPlugin(id));
    }

    @Override
    public boolean isInUploadingState(String fileName) {
        return this.uploadingPlugins.asMap().containsKey(fileName);
    }

    @Override
    public IntegrationType uploadPlugin(String uploadedPluginName, InputStream fileStream) {
        PluginInfo newPluginInfo = this.resolvePluginInfo(uploadedPluginName, fileStream);
        IntegrationTypeDetails pluginDetails = this.pluginLoader.resolvePluginDetails(newPluginInfo);
        Optional<PluginWrapper> previousPlugin = this.getPluginById(newPluginInfo.getId());
        previousPlugin.ifPresent(this::unloadPreviousPlugin);
        return Optional.ofNullable(this.pluginManager.loadPlugin(Paths.get(this.pluginsTempDir, uploadedPluginName))).map(pluginId -> {
            IntegrationTypeDetails newPluginDetails = this.copyPlugin(newPluginInfo, pluginDetails, uploadedPluginName);
            try {
                IntegrationType newIntegrationType = this.startUpPlugin(newPluginDetails);
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new PluginEvent(newIntegrationType.getName(), LOAD_KEY));
                previousPlugin.ifPresent(this::deletePreviousPlugin);
                this.deleteTempPlugin(uploadedPluginName);
                return newIntegrationType;
            }
            catch (Exception ex) {
                previousPlugin.ifPresent(p -> this.loadPreviousPlugin((PluginWrapper)p, newPluginDetails));
                Throwable exception = ex;
                Object exMessage = exception.toString();
                while (exception.getCause() != null) {
                    exception = exception.getCause();
                    exMessage = (String)exMessage + exception.toString() + "\n";
                }
                throw new ReportPortalException(ErrorType.PLUGIN_UPLOAD_ERROR, new Object[]{exMessage});
            }
        }).orElseThrow(() -> {
            previousPlugin.ifPresent(p -> this.loadPreviousPlugin((PluginWrapper)p, pluginDetails));
            this.deleteTempPlugin(uploadedPluginName);
            throw new ReportPortalException(ErrorType.PLUGIN_UPLOAD_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Failed to load new plugin from file = '{}'", (Object[])new Object[]{uploadedPluginName}).get()});
        });
    }

    private PluginInfo resolvePluginInfo(String fileName, InputStream fileStream) {
        Path tempPluginPath = this.uploadTempPlugin(fileName, fileStream);
        try {
            PluginInfo newPluginInfo = this.pluginLoader.extractPluginInfo(tempPluginPath);
            BusinessRule.expect((Object)this.validatePluginMetaInfo(newPluginInfo), (Predicate)Predicates.equalTo((Object)Boolean.TRUE)).verify(ErrorType.PLUGIN_UPLOAD_ERROR, new Object[]{"Plugin version should be specified."});
            return newPluginInfo;
        }
        catch (PluginRuntimeException e) {
            this.removeUploadingPlugin(fileName);
            throw new ReportPortalException(ErrorType.PLUGIN_UPLOAD_ERROR, new Object[]{e.getMessage()});
        }
    }

    private Path uploadTempPlugin(String fileName, InputStream fileStream) {
        Path pluginsTempDirPath = Paths.get(this.pluginsTempDir, new String[0]);
        this.createTempPluginsFolderIfNotExists(pluginsTempDirPath);
        this.validateFileExtension(fileName);
        try {
            Path pluginPath = Paths.get(this.pluginsTempDir, fileName);
            this.addUploadingPlugin(fileName, pluginPath);
            this.pluginLoader.savePlugin(pluginPath, fileStream);
            return pluginPath;
        }
        catch (IOException e) {
            this.removeUploadingPlugin(fileName);
            throw new ReportPortalException(ErrorType.PLUGIN_UPLOAD_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Unable to copy the new plugin file with name = '{}' to the temp directory", (Object[])new Object[]{fileName}).get()});
        }
    }

    private void createTempPluginsFolderIfNotExists(Path path) {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new ReportPortalException(ErrorType.PLUGIN_UPLOAD_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Unable to create directory = '{}'", (Object[])new Object[]{path}).get()});
            }
        }
    }

    private void validateFileExtension(String fileName) {
        String resolvedExtension = FilenameUtils.getExtension((String)fileName);
        Optional byExtension = PluginFileExtension.findByExtension((String)("." + resolvedExtension));
        BusinessRule.expect((Object)byExtension, Optional::isPresent).verify(ErrorType.PLUGIN_UPLOAD_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Unsupported plugin file extension = '{}'", (Object[])new Object[]{resolvedExtension}).get()});
    }

    private void addUploadingPlugin(String fileName, Path path) {
        this.uploadingPlugins.put((Object)fileName, (Object)path);
    }

    private boolean validatePluginMetaInfo(PluginInfo newPluginInfo) {
        return Optional.ofNullable(newPluginInfo.getVersion()).map(StringUtils::isNotBlank).orElse(Boolean.FALSE);
    }

    private void unloadPreviousPlugin(PluginWrapper pluginWrapper) {
        this.destroyDependency(pluginWrapper.getPluginId());
        if (!this.pluginManager.unloadPlugin(pluginWrapper.getPluginId())) {
            throw new ReportPortalException(ErrorType.PLUGIN_REMOVE_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Failed to stop old plugin with id = '{}'", (Object[])new Object[]{pluginWrapper.getPluginId()}).get()});
        }
    }

    private void destroyDependency(String name) {
        AbstractAutowireCapableBeanFactory beanFactory = (AbstractAutowireCapableBeanFactory)this.autowireCapableBeanFactory;
        if (beanFactory.containsSingleton(name)) {
            beanFactory.destroySingleton(name);
        }
    }

    private IntegrationTypeDetails copyPlugin(PluginInfo newPluginInfo, IntegrationTypeDetails pluginDetails, String uploadedPluginName) {
        String newPluginId = newPluginInfo.getId();
        this.startUpPlugin(newPluginId);
        this.validateNewPluginExtensionClasses(newPluginId, uploadedPluginName);
        this.pluginManager.unloadPlugin(newPluginId);
        if (newPluginInfo.getDetails() != null) {
            pluginDetails.setDetails(newPluginInfo.getDetails());
        }
        String newPluginFileName = this.generatePluginFileName(newPluginInfo, uploadedPluginName);
        IntegrationTypeProperties.FILE_NAME.setValue(pluginDetails, (Object)newPluginFileName);
        String fileId = this.savePlugin(uploadedPluginName, newPluginFileName);
        IntegrationTypeProperties.FILE_ID.setValue(pluginDetails, (Object)fileId);
        this.copyPluginToRootDirectory(newPluginId, fileId, newPluginFileName);
        this.removeUploadingPlugin(uploadedPluginName);
        return pluginDetails;
    }

    private void validateNewPluginExtensionClasses(String newPluginId, String newPluginFileName) {
        PluginWrapper newPlugin = this.getPluginById(newPluginId).orElseThrow(() -> new ReportPortalException(ErrorType.PLUGIN_UPLOAD_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Plugin with id = '{}' has not been found.", (Object[])new Object[]{newPluginId}).get()}));
        if (!this.pluginLoader.validatePluginExtensionClasses(newPlugin)) {
            this.pluginManager.unloadPlugin(newPluginId);
            this.deleteTempPlugin(newPluginFileName);
            throw new ReportPortalException(ErrorType.PLUGIN_UPLOAD_ERROR, new Object[]{Suppliers.formattedSupplier((String)"New plugin with id = '{}' doesn't have mandatory extension classes.", (Object[])new Object[]{newPluginId}).get()});
        }
    }

    private void deleteTempPlugin(String tempPluginFileName) {
        try {
            this.pluginLoader.deleteTempPlugin(this.pluginsTempDir, tempPluginFileName);
        }
        catch (IOException e) {
            LOGGER.error("Error during temp plugin file removing: '{}'", (Object)e.getMessage());
        }
        finally {
            this.removeUploadingPlugin(tempPluginFileName);
        }
    }

    private String generatePluginFileName(PluginInfo pluginInfo, String originalFileName) {
        return pluginInfo.getId() + "-" + pluginInfo.getVersion() + "." + FilenameUtils.getExtension((String)originalFileName);
    }

    private String savePlugin(String uploadedPluginName, String newPluginFileName) {
        String string;
        block8: {
            FileInputStream fileStream = FileUtils.openInputStream((File)FileUtils.getFile((String[])new String[]{this.pluginsTempDir, uploadedPluginName}));
            try {
                string = this.pluginLoader.saveToDataStore(newPluginFileName, fileStream);
                if (fileStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (fileStream != null) {
                        try {
                            ((InputStream)fileStream).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ReportPortalException(ErrorType.PLUGIN_UPLOAD_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Unable to upload new plugin file = '{}' to the data store", (Object[])new Object[]{uploadedPluginName}).get()});
                }
            }
            ((InputStream)fileStream).close();
        }
        return string;
    }

    private void copyPluginToRootDirectory(String newPluginId, String fileId, String newPluginFileName) {
        try {
            this.pluginLoader.copyFromDataStore(fileId, Paths.get(this.pluginsDir, newPluginFileName), Paths.get(this.resourcesDir, newPluginId));
        }
        catch (IOException e) {
            throw new ReportPortalException(ErrorType.PLUGIN_UPLOAD_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Unable to copy new plugin file = '{}' from the data store to the root directory", (Object[])new Object[]{newPluginFileName}).get()});
        }
    }

    private void removeUploadingPlugin(String fileName) {
        this.uploadingPlugins.invalidate((Object)fileName);
    }

    private IntegrationType startUpPlugin(IntegrationTypeDetails pluginDetails) {
        String newPluginFileName = IntegrationTypeProperties.FILE_NAME.getValue(pluginDetails.getDetails()).map(String::valueOf).orElseThrow(() -> new ReportPortalException(ErrorType.PLUGIN_UPLOAD_ERROR, new Object[]{"Unable to resolve 'fileName' property"}));
        return Optional.ofNullable(this.pluginManager.loadPlugin(Paths.get(this.pluginsDir, newPluginFileName))).map(newLoadedPluginId -> {
            this.startUpPlugin((String)newLoadedPluginId);
            Optional oldIntegrationType = this.integrationTypeRepository.findByName(newLoadedPluginId);
            oldIntegrationType.ifPresent(it -> IntegrationTypeProperties.FILE_ID.getValue(pluginDetails.getDetails()).map(String::valueOf).ifPresent(fileId -> this.deletePreviousPluginFile((IntegrationType)it, (String)fileId)));
            IntegrationTypeBuilder integrationTypeBuilder = oldIntegrationType.map(IntegrationTypeBuilder::new).orElseGet(IntegrationTypeBuilder::new);
            integrationTypeBuilder.setName((String)newLoadedPluginId).setIntegrationGroup(IntegrationGroupEnum.OTHER).setPluginType(PluginTypeEnum.EXTENSION);
            Optional<ReportPortalExtensionPoint> instance = this.getInstance((String)newLoadedPluginId, (Class)ReportPortalExtensionPoint.class);
            instance.ifPresent(extensionPoint -> {
                pluginDetails.getDetails().putAll(extensionPoint.getPluginParams());
                pluginDetails.getDetails().put(IntegrationTypeProperties.RESOURCES_DIRECTORY.getAttribute(), Paths.get(this.resourcesDir, newLoadedPluginId).toString());
                integrationTypeBuilder.setDetails(pluginDetails);
                integrationTypeBuilder.setIntegrationGroup(IntegrationGroupEnum.valueOf((String)extensionPoint.getIntegrationGroup().name()));
            });
            integrationTypeBuilder.setEnabled(true);
            return (IntegrationType)this.integrationTypeRepository.save((Object)integrationTypeBuilder.get());
        }).orElseThrow(() -> new ReportPortalException(ErrorType.PLUGIN_UPLOAD_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Error during loading the plugin file = '{}'", (Object[])new Object[]{newPluginFileName}).get()}));
    }

    private void deletePreviousPluginFile(IntegrationType oldIntegrationType, String newFileId) {
        try {
            Optional.ofNullable(oldIntegrationType.getDetails()).flatMap(details -> Optional.ofNullable(details.getDetails())).flatMap(arg_0 -> ((IntegrationTypeProperties)IntegrationTypeProperties.FILE_ID).getValue(arg_0)).map(String::valueOf).ifPresent(oldFileId -> {
                if (!oldFileId.equals(newFileId)) {
                    this.pluginLoader.deleteFromDataStore((String)oldFileId);
                }
            });
        }
        catch (Exception ex) {
            LOGGER.error("Error during removing old plugin file from the Data store: {}", (Object)ex.getMessage());
        }
    }

    private void deletePreviousPlugin(PluginWrapper previousPlugin) {
        try {
            Files.deleteIfExists(previousPlugin.getPluginPath());
        }
        catch (IOException e) {
            LOGGER.error("Unable to delete the old plugin file with id = '{}'", (Object)previousPlugin.getPluginId());
        }
    }

    private PluginState loadPreviousPlugin(PluginWrapper previousPlugin, IntegrationTypeDetails newPluginDetails) {
        if (previousPlugin.getPluginState() == PluginState.STARTED) {
            return previousPlugin.getPluginState();
        }
        IntegrationTypeProperties.FILE_ID.getValue(newPluginDetails.getDetails()).map(String::valueOf).ifPresent(fileId -> {
            try {
                this.pluginLoader.deleteFromDataStore((String)fileId);
            }
            catch (Exception e) {
                LOGGER.error("Unable to delete new plugin file from the DataStore: '{}'", (Object)e.getMessage());
            }
        });
        PluginState pluginState = Optional.ofNullable(this.pluginManager.getPlugin(previousPlugin.getPluginId())).map(loadedPlugin -> {
            if (previousPlugin.getDescriptor().getVersion().equals(loadedPlugin.getDescriptor().getVersion())) {
                return loadedPlugin.getPluginState();
            }
            this.pluginManager.deletePlugin(loadedPlugin.getPluginId());
            this.deletePluginResources(String.valueOf(Paths.get(this.resourcesDir, loadedPlugin.getPluginId())));
            return PluginState.DISABLED;
        }).orElse(PluginState.DISABLED);
        if (pluginState != PluginState.STARTED) {
            try {
                Path oldPluginPath = previousPlugin.getPluginPath();
                PluginInfo oldPluginInfo = this.pluginLoader.extractPluginInfo(oldPluginPath);
                String oldPluginFileName = this.generatePluginFileName(oldPluginInfo, oldPluginPath.toFile().getName());
                try (InputStream fileStream = Files.newInputStream(oldPluginPath, new OpenOption[0]);){
                    this.pluginLoader.saveToDataStore(oldPluginFileName, fileStream);
                }
                catch (Exception e) {
                    throw new ReportPortalException(ErrorType.PLUGIN_UPLOAD_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Unable to upload old plugin file = '{}' to the data store", (Object[])new Object[]{oldPluginFileName}).get()});
                }
                this.copyPluginResources(oldPluginPath, previousPlugin.getPluginId());
                return this.startUpPlugin(Optional.ofNullable(this.pluginManager.loadPlugin(oldPluginPath)).orElseThrow(() -> new ReportPortalException(ErrorType.PLUGIN_UPLOAD_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Unable to reload previousPlugin with id = '{}': '{}'", (Object[])new Object[]{previousPlugin.getPluginId()}).get()})));
            }
            catch (PluginRuntimeException e) {
                throw new ReportPortalException(ErrorType.PLUGIN_UPLOAD_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Unable to reload previousPlugin with id = '{}': '{}'", (Object[])new Object[]{previousPlugin.getPluginId(), e.getMessage()}).get()});
            }
        }
        return PluginState.STARTED;
    }
}

