/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.model.user;

import com.epam.ta.reportportal.ws.annotations.In;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CreateUserRQFull {
    @JsonProperty(value="active", defaultValue="true")
    @Schema(requiredMode=Schema.RequiredMode.NOT_REQUIRED, defaultValue="true")
    private boolean active = true;
    @JsonProperty(value="externalId")
    @Schema(requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    private String externalId;
    @In(allowedValues={"INTERNAL", "SCIM"})
    @JsonProperty(value="accountType")
    @Schema(requiredMode=Schema.RequiredMode.NOT_REQUIRED, allowableValues={"INTERNAL, SCIM"})
    private String accountType;
    @NotBlank
    @Pattern(regexp="[a-zA-Z0-9-_.]+")
    @Size(min=1, max=128)
    @JsonProperty(value="login", required=true)
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, example="string")
    private @NotBlank @Pattern(regexp="[a-zA-Z0-9-_.]+") @Size(min=1, max=128) String login;
    @Size(max=256)
    @JsonProperty(value="password")
    @Schema(requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @Pattern(regexp="^(?=.*\\d)(?=.*[A-Z])(?=.*[a-z])(?=.*[^a-zA-Z\\d\\s])([^\\s]){8,256}$")
    private @Size(max=256) @Pattern(regexp="^(?=.*\\d)(?=.*[A-Z])(?=.*[a-z])(?=.*[^a-zA-Z\\d\\s])([^\\s]){8,256}$") String password;
    @NotBlank
    @Pattern(regexp="[\\pL0-9-_ \\.]+")
    @Size(min=3, max=256)
    @JsonProperty(value="fullName", required=true)
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, example="string")
    private @NotBlank @Pattern(regexp="[\\pL0-9-_ \\.]+") @Size(min=3, max=256) String fullName;
    @NotBlank
    @JsonProperty(value="email", required=true)
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED)
    private String email;
    @NotNull
    @JsonProperty(value="accountRole", required=true)
    @In(allowedValues={"user", "administrator"})
    @Schema(requiredMode=Schema.RequiredMode.NOT_REQUIRED, allowableValues={"USER, ADMINISTRATOR"})
    private String accountRole;
    @JsonProperty(value="projectRole")
    @In(allowedValues={"operator", "customer", "member", "project_manager"})
    @Schema(requiredMode=Schema.RequiredMode.NOT_REQUIRED, allowableValues={"CUSTOMER, MEMBER, PROJECT_MANAGER"})
    private String projectRole;
    @JsonProperty(value="defaultProject")
    @Schema(requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    private String defaultProject;

    @Generated
    public CreateUserRQFull() {
    }

    @Generated
    public boolean isActive() {
        return this.active;
    }

    @Generated
    public String getExternalId() {
        return this.externalId;
    }

    @Generated
    public String getAccountType() {
        return this.accountType;
    }

    @Generated
    public String getLogin() {
        return this.login;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getFullName() {
        return this.fullName;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getAccountRole() {
        return this.accountRole;
    }

    @Generated
    public String getProjectRole() {
        return this.projectRole;
    }

    @Generated
    public String getDefaultProject() {
        return this.defaultProject;
    }

    @JsonProperty(value="active", defaultValue="true")
    @Generated
    public void setActive(boolean active) {
        this.active = active;
    }

    @JsonProperty(value="externalId")
    @Generated
    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    @JsonProperty(value="accountType")
    @Generated
    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    @JsonProperty(value="login", required=true)
    @Generated
    public void setLogin(String login) {
        this.login = login;
    }

    @JsonProperty(value="password")
    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @JsonProperty(value="fullName", required=true)
    @Generated
    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    @JsonProperty(value="email", required=true)
    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @JsonProperty(value="accountRole", required=true)
    @Generated
    public void setAccountRole(String accountRole) {
        this.accountRole = accountRole;
    }

    @JsonProperty(value="projectRole")
    @Generated
    public void setProjectRole(String projectRole) {
        this.projectRole = projectRole;
    }

    @JsonProperty(value="defaultProject")
    @Generated
    public void setDefaultProject(String defaultProject) {
        this.defaultProject = defaultProject;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateUserRQFull)) {
            return false;
        }
        CreateUserRQFull other = (CreateUserRQFull)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isActive() != other.isActive()) {
            return false;
        }
        String this$externalId = this.getExternalId();
        String other$externalId = other.getExternalId();
        if (this$externalId == null ? other$externalId != null : !this$externalId.equals(other$externalId)) {
            return false;
        }
        String this$accountType = this.getAccountType();
        String other$accountType = other.getAccountType();
        if (this$accountType == null ? other$accountType != null : !this$accountType.equals(other$accountType)) {
            return false;
        }
        String this$login = this.getLogin();
        String other$login = other.getLogin();
        if (this$login == null ? other$login != null : !this$login.equals(other$login)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$fullName = this.getFullName();
        String other$fullName = other.getFullName();
        if (this$fullName == null ? other$fullName != null : !this$fullName.equals(other$fullName)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$accountRole = this.getAccountRole();
        String other$accountRole = other.getAccountRole();
        if (this$accountRole == null ? other$accountRole != null : !this$accountRole.equals(other$accountRole)) {
            return false;
        }
        String this$projectRole = this.getProjectRole();
        String other$projectRole = other.getProjectRole();
        if (this$projectRole == null ? other$projectRole != null : !this$projectRole.equals(other$projectRole)) {
            return false;
        }
        String this$defaultProject = this.getDefaultProject();
        String other$defaultProject = other.getDefaultProject();
        return !(this$defaultProject == null ? other$defaultProject != null : !this$defaultProject.equals(other$defaultProject));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CreateUserRQFull;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isActive() ? 79 : 97);
        String $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : $externalId.hashCode());
        String $accountType = this.getAccountType();
        result = result * 59 + ($accountType == null ? 43 : $accountType.hashCode());
        String $login = this.getLogin();
        result = result * 59 + ($login == null ? 43 : $login.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $fullName = this.getFullName();
        result = result * 59 + ($fullName == null ? 43 : $fullName.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $accountRole = this.getAccountRole();
        result = result * 59 + ($accountRole == null ? 43 : $accountRole.hashCode());
        String $projectRole = this.getProjectRole();
        result = result * 59 + ($projectRole == null ? 43 : $projectRole.hashCode());
        String $defaultProject = this.getDefaultProject();
        result = result * 59 + ($defaultProject == null ? 43 : $defaultProject.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CreateUserRQFull(active=" + this.isActive() + ", externalId=" + this.getExternalId() + ", accountType=" + this.getAccountType() + ", login=" + this.getLogin() + ", password=" + this.getPassword() + ", fullName=" + this.getFullName() + ", email=" + this.getEmail() + ", accountRole=" + this.getAccountRole() + ", projectRole=" + this.getProjectRole() + ", defaultProject=" + this.getDefaultProject() + ")";
    }
}

