/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.health;

import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class JobsHealthIndicator
extends AbstractHealthIndicator {
    private static Logger LOGGER = LoggerFactory.getLogger(JobsHealthIndicator.class);
    private static final String ERROR_MESSAGE = "Jobs service health check failed";
    private final RestTemplate restTemplate;
    @Value(value="${rp.jobs.baseUrl}")
    private String jobsBaseUrl;

    public JobsHealthIndicator(RestTemplate restTemplate) {
        super(ERROR_MESSAGE);
        this.restTemplate = restTemplate;
    }

    protected void doHealthCheck(Health.Builder builder) {
        try {
            Map jobsHealthRs = (Map)this.restTemplate.getForObject(this.jobsBaseUrl + "/health", Map.class, new Object[0]);
            Status jobsStatus = new Status((String)jobsHealthRs.get("status"));
            builder.status(jobsStatus);
            Optional.ofNullable(jobsHealthRs.get("components")).map(Map.class::cast).ifPresent(arg_0 -> ((Health.Builder)builder).withDetails(arg_0));
            builder.build();
        }
        catch (Exception e) {
            LOGGER.error("{} : {}", (Object)ERROR_MESSAGE, (Object)e.getMessage());
            builder.unknown().withException((Throwable)e).build();
        }
    }

    public Health getHealth(boolean includeDetails) {
        return super.getHealth(includeDetails);
    }
}

