/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.demodata.service.generator;

import com.epam.ta.reportportal.demodata.model.DemoItemMetadata;
import com.epam.ta.reportportal.demodata.model.RootMetaData;
import com.epam.ta.reportportal.demodata.model.Suite;
import com.epam.ta.reportportal.demodata.model.Test;
import com.epam.ta.reportportal.demodata.service.ContentUtils;
import com.epam.ta.reportportal.demodata.service.DemoDataTestItemService;
import com.epam.ta.reportportal.demodata.service.DemoLogsService;
import com.epam.ta.reportportal.demodata.service.generator.SuiteGenerator;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.enums.TestItemTypeEnum;
import com.epam.ta.reportportal.entity.log.Log;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultSuiteGenerator
implements SuiteGenerator {
    public static final int BEFORE_AFTER_LOGS_COUNT = 2;
    public static final int SUITE_LOGS_COUNT = 3;
    public static final int TEST_LOGS_COUNT = 3;
    public static final int STEP_LOGS_COUNT = 5;
    protected final DemoDataTestItemService demoDataTestItemService;
    private final DemoLogsService demoLogsService;

    @Autowired
    public DefaultSuiteGenerator(DemoDataTestItemService demoDataTestItemService, DemoLogsService demoLogsService) {
        this.demoDataTestItemService = demoDataTestItemService;
        this.demoLogsService = demoLogsService;
    }

    @Override
    public void generateSuites(Suite suite, RootMetaData rootMetaData) {
        StatusEnum suiteStatus = StatusEnum.valueOf((String)suite.getStatus());
        if (suite.isHasBefore()) {
            DemoItemMetadata beforeMetaData = this.getMetadata(ContentUtils.getNameFromType(TestItemTypeEnum.BEFORE_SUITE), TestItemTypeEnum.BEFORE_SUITE, suiteStatus, null).withLogCount(2);
            this.createStep(beforeMetaData, rootMetaData);
        }
        DemoItemMetadata suiteMetaData = this.getMetadata(suite.getName(), TestItemTypeEnum.SUITE, suiteStatus, null);
        String suiteId = this.demoDataTestItemService.startRootItem(suiteMetaData, rootMetaData);
        suite.getTests().forEach(test -> {
            StatusEnum testStatus = StatusEnum.valueOf((String)test.getStatus());
            if (test.isHasBefore()) {
                DemoItemMetadata beforeMetaData = this.getMetadata(ContentUtils.getNameFromType(TestItemTypeEnum.BEFORE_CLASS), TestItemTypeEnum.BEFORE_CLASS, testStatus, suiteId).withLogCount(2);
                this.createStep(beforeMetaData, rootMetaData);
            }
            this.generateTest(suiteId, rootMetaData, (Test)test, testStatus);
            if (test.isHasAfter()) {
                DemoItemMetadata afterMetaData = this.getMetadata(ContentUtils.getNameFromType(TestItemTypeEnum.AFTER_CLASS), TestItemTypeEnum.AFTER_CLASS, testStatus, suiteId).withLogCount(2);
                this.createStep(afterMetaData, rootMetaData);
            }
        });
        this.demoDataTestItemService.finishTestItem(suiteId, suiteStatus, rootMetaData);
        this.generateLogs(3, suiteId, suiteStatus, rootMetaData);
        if (suite.isHasAfter()) {
            this.createStep(this.getMetadata(ContentUtils.getNameFromType(TestItemTypeEnum.AFTER_SUITE), TestItemTypeEnum.AFTER_SUITE, suiteStatus, null).withLogCount(2), rootMetaData);
        }
    }

    protected DemoItemMetadata getMetadata(String name, TestItemTypeEnum type, StatusEnum status, String parentId) {
        return new DemoItemMetadata().withName(name).withType(type).withStatus(status).withParentId(parentId);
    }

    protected void createStep(DemoItemMetadata stepMetaData, RootMetaData rootMetaData) {
        String stepId = Optional.ofNullable(stepMetaData.getParentId()).map(parentId -> this.demoDataTestItemService.startTestItem(stepMetaData, rootMetaData)).orElseGet(() -> this.demoDataTestItemService.startRootItem(stepMetaData, rootMetaData));
        this.generateLogs(stepMetaData.getLogCount(), stepId, stepMetaData.getStatus(), rootMetaData);
        Optional.ofNullable(stepMetaData.getIssue()).ifPresentOrElse(issue -> this.demoDataTestItemService.finishTestItem(stepId, stepMetaData.getStatus(), rootMetaData, (String)issue), () -> this.demoDataTestItemService.finishTestItem(stepId, stepMetaData.getStatus(), rootMetaData));
    }

    protected void generateTest(String suiteId, RootMetaData rootMetaData, Test test, StatusEnum testStatus) {
        String testId = this.startTest(suiteId, rootMetaData, test, testStatus);
        this.generateSteps(rootMetaData, test, testId);
        Optional.ofNullable(test.getIssue()).ifPresentOrElse(issue -> this.demoDataTestItemService.finishTestItem(testId, testStatus, rootMetaData, (String)issue), () -> this.demoDataTestItemService.finishTestItem(testId, testStatus, rootMetaData));
        this.generateLogs(3, testId, testStatus, rootMetaData);
    }

    protected String startTest(String suiteId, RootMetaData rootMetaData, Test test, StatusEnum testStatus) {
        DemoItemMetadata testMetaData = this.getMetadata(test.getName(), TestItemTypeEnum.TEST, testStatus, suiteId).withIssue(test.getIssue());
        return this.demoDataTestItemService.startTestItem(testMetaData, rootMetaData);
    }

    private void generateSteps(RootMetaData rootMetaData, Test test, String testId) {
        test.getSteps().forEach(step -> {
            StatusEnum stepStatus = StatusEnum.valueOf((String)step.getStatus());
            if (step.isHasBefore()) {
                DemoItemMetadata beforeMetaData = this.getMetadata(ContentUtils.getNameFromType(TestItemTypeEnum.BEFORE_METHOD), TestItemTypeEnum.BEFORE_METHOD, stepStatus, testId).withLogCount(2);
                this.createStep(beforeMetaData, rootMetaData);
            }
            DemoItemMetadata stepMetaData = this.getMetadata(step.getName(), TestItemTypeEnum.STEP, stepStatus, testId).withLogCount(5).withIssue(step.getIssue());
            this.createStep(stepMetaData, rootMetaData);
            if (step.isHasBefore()) {
                DemoItemMetadata afterMetaData = this.getMetadata(ContentUtils.getNameFromType(TestItemTypeEnum.AFTER_METHOD), TestItemTypeEnum.AFTER_METHOD, stepStatus, testId).withLogCount(2);
                this.createStep(afterMetaData, rootMetaData);
            }
        });
    }

    private void generateLogs(int count, String itemId, StatusEnum status, RootMetaData rootMetaData) {
        Long projectId = rootMetaData.getProjectDetails().getProjectId();
        List<Log> logs = this.demoLogsService.generateItemLogs(count, projectId, itemId, status);
        this.demoLogsService.attachFiles(logs, projectId, itemId, rootMetaData.getLaunchUuid());
    }
}

