/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.demodata.service;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.demodata.model.DemoDataRq;
import com.epam.ta.reportportal.demodata.model.DemoDataRs;
import com.epam.ta.reportportal.demodata.service.DemoDashboardsService;
import com.epam.ta.reportportal.demodata.service.DemoDataFacade;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DemoDataService {
    private final DemoDashboardsService demoDashboardsService;
    private final DemoDataFacade demoDataFacade;

    @Autowired
    public DemoDataService(DemoDashboardsService demoDashboardsService, DemoDataFacade demoDataFacade) {
        this.demoDashboardsService = demoDashboardsService;
        this.demoDataFacade = demoDataFacade;
    }

    public DemoDataRs generate(DemoDataRq demoDataRq, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        DemoDataRs demoDataRs = new DemoDataRs();
        List<Long> launchIds = this.demoDataFacade.generateDemoLaunches(user, projectDetails);
        demoDataRs.setLaunchIds(launchIds);
        if (demoDataRq.isCreateDashboard()) {
            this.demoDashboardsService.generate(user, projectDetails.getProjectId()).ifPresent(it -> demoDataRs.setDashboardId(it.getId()));
        }
        return demoDataRs;
    }
}

