/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content.updater.validator;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.core.widget.content.updater.validator.WidgetValidatorStrategy;
import com.epam.ta.reportportal.core.widget.util.WidgetOptionUtil;
import com.epam.ta.reportportal.entity.widget.WidgetOptions;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class PassingRatePerLaunchContentValidator
implements WidgetValidatorStrategy {
    @Override
    public void validate(List<String> contentFields, Map<Filter, Sort> filterSortMapping, WidgetOptions widgetOptions, int limit) {
        this.validateFilterSortMapping(filterSortMapping);
        this.validateWidgetOptions(widgetOptions);
    }

    private void validateFilterSortMapping(Map<Filter, Sort> filterSortMapping) {
        BusinessRule.expect((Object)MapUtils.isNotEmpty(filterSortMapping), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Filter-Sort mapping should not be empty"});
    }

    private void validateWidgetOptions(WidgetOptions widgetOptions) {
        BusinessRule.expect((Object)WidgetOptionUtil.getValueByKey("launchNameFilter", widgetOptions), StringUtils::isNotEmpty).verify(ErrorType.UNABLE_LOAD_WIDGET_CONTENT, new Object[]{"launchNameFilter should be specified for widget."});
    }
}

