/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content.remover;

import com.epam.ta.reportportal.core.widget.content.materialized.generator.MaterializedViewNameGenerator;
import com.epam.ta.reportportal.core.widget.content.remover.WidgetContentRemover;
import com.epam.ta.reportportal.dao.StaleMaterializedViewRepository;
import com.epam.ta.reportportal.entity.materialized.StaleMaterializedView;
import com.epam.ta.reportportal.entity.widget.Widget;
import java.time.Instant;
import org.springframework.stereotype.Service;

@Service
public class StaleMaterializedViewRemover
implements WidgetContentRemover {
    private final MaterializedViewNameGenerator materializedViewNameGenerator;
    private final StaleMaterializedViewRepository staleMaterializedViewRepository;

    public StaleMaterializedViewRemover(MaterializedViewNameGenerator materializedViewNameGenerator, StaleMaterializedViewRepository staleMaterializedViewRepository) {
        this.materializedViewNameGenerator = materializedViewNameGenerator;
        this.staleMaterializedViewRepository = staleMaterializedViewRepository;
    }

    @Override
    public void removeContent(Widget widget) {
        StaleMaterializedView staleView = this.getStaleView(widget);
        this.staleMaterializedViewRepository.insert(staleView);
    }

    private StaleMaterializedView getStaleView(Widget widget) {
        String viewName = this.materializedViewNameGenerator.generate(widget);
        StaleMaterializedView view = new StaleMaterializedView();
        view.setName(viewName);
        view.setCreationDate(Instant.now());
        return view;
    }
}

