/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content.loader.materialized;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.core.widget.content.loader.materialized.MaterializedWidgetContentLoader;
import com.epam.ta.reportportal.core.widget.util.WidgetOptionUtil;
import com.epam.ta.reportportal.dao.WidgetContentRepository;
import com.epam.ta.reportportal.entity.widget.Widget;
import com.epam.ta.reportportal.entity.widget.WidgetOptions;
import com.epam.ta.reportportal.entity.widget.content.healthcheck.HealthCheckTableContent;
import com.epam.ta.reportportal.entity.widget.content.healthcheck.HealthCheckTableGetParams;
import com.epam.ta.reportportal.entity.widget.content.healthcheck.LevelEntry;
import com.epam.ta.reportportal.model.widget.SortEntry;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;

@Service(value="healthCheckTableReadyContentLoader")
public class HealthCheckTableReadyContentLoader
implements MaterializedWidgetContentLoader {
    public static final String SORT = "sort";
    public static final String CUSTOM_COLUMN = "customColumn";
    public static final String TOTAL = "total";
    public static final String STATISTICS = "statistics";
    public static final String PASSING_RATE = "passingRate";
    private final WidgetContentRepository widgetContentRepository;
    private final ObjectMapper objectMapper;

    @Autowired
    public HealthCheckTableReadyContentLoader(WidgetContentRepository widgetContentRepository, ObjectMapper objectMapper) {
        this.widgetContentRepository = widgetContentRepository;
        this.objectMapper = objectMapper;
    }

    @Override
    public Map<String, Object> loadContent(Widget widget, MultiValueMap<String, String> params) {
        HealthCheckTableGetParams getParams = this.getParams(widget.getWidgetOptions(), Optional.ofNullable((List)params.get((Object)"attributes")).map(attributes -> attributes.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList())).orElseGet(Collections::emptyList));
        List content = this.widgetContentRepository.componentHealthCheckTable(getParams);
        if (CollectionUtils.isEmpty((Collection)content)) {
            return Collections.emptyMap();
        }
        Map<String, Integer> totalStatistics = content.stream().map(HealthCheckTableContent::getStatistics).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.summingInt(Map.Entry::getValue)));
        return ImmutableMap.builder().put((Object)"result", (Object)content).put((Object)TOTAL, (Object)ImmutableMap.builder().put((Object)STATISTICS, totalStatistics).put((Object)PASSING_RATE, (Object)this.calculatePassingRate(totalStatistics)).build()).build();
    }

    private HealthCheckTableGetParams getParams(WidgetOptions widgetOptions, List<String> attributeValues) {
        List<String> attributeKeys = WidgetOptionUtil.getListByKey("attributeKeys", widgetOptions);
        int currentLevel = attributeValues.size();
        BusinessRule.expect(attributeKeys, keys -> keys.size() > currentLevel).verify(ErrorType.UNABLE_LOAD_WIDGET_CONTENT, new Object[]{"Incorrect level definition"});
        String viewName = Optional.ofNullable(WidgetOptionUtil.getValueByKey("viewName", widgetOptions)).orElseThrow(() -> new ReportPortalException(ErrorType.UNABLE_LOAD_WIDGET_CONTENT, new Object[]{"Widget view name not provided"}));
        String currentLevelKey = (String)attributeKeys.get(currentLevel);
        boolean includeCustomColumn = Optional.ofNullable(WidgetOptionUtil.getValueByKey(CUSTOM_COLUMN, widgetOptions)).isPresent();
        return HealthCheckTableGetParams.of((String)viewName, (String)currentLevelKey, (Sort)this.resolveSort(widgetOptions), (boolean)includeCustomColumn, this.getLevelEntries(attributeKeys, attributeValues), (Boolean)WidgetOptionUtil.getBooleanByKey("excludeSkipped", widgetOptions));
    }

    private Sort resolveSort(WidgetOptions widgetOptions) {
        return Optional.ofNullable(widgetOptions).flatMap(wo -> Optional.ofNullable(wo.getOptions()).map(options -> options.get(SORT))).map(s -> {
            try {
                SortEntry sortEntry = (SortEntry)this.objectMapper.readValue(this.objectMapper.writeValueAsString(s), SortEntry.class);
                return Sort.by((Sort.Direction)(sortEntry.isAsc() ? Sort.Direction.ASC : Sort.Direction.DESC), (String[])new String[]{sortEntry.getSortingColumn()});
            }
            catch (JsonProcessingException e) {
                throw new ReportPortalException(ErrorType.UNABLE_LOAD_WIDGET_CONTENT, new Object[]{"Sort format error: " + e.getMessage()});
            }
        }).orElseThrow(() -> new ReportPortalException(ErrorType.UNABLE_LOAD_WIDGET_CONTENT, new Object[]{"Sort parameter not provided"}));
    }

    private List<LevelEntry> getLevelEntries(List<String> attributeKeys, List<String> attributeValues) {
        return IntStream.range(0, attributeValues.size()).mapToObj(index -> {
            String attributeKey = (String)attributeKeys.get(index);
            String attributeValue = (String)attributeValues.get(index);
            return LevelEntry.of((String)attributeKey, (String)attributeValue);
        }).collect(Collectors.toList());
    }

    private double calculatePassingRate(Map<String, Integer> totalStatistics) {
        double passingRate = 100.0 * (double)totalStatistics.getOrDefault("statistics$executions$passed", 0).intValue() / (double)totalStatistics.getOrDefault("statistics$executions$total", 1).intValue();
        return BigDecimal.valueOf(passingRate).setScale(2, RoundingMode.HALF_UP).doubleValue();
    }
}

