/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content.loader;

import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.core.widget.content.LoadContentStrategy;
import com.epam.ta.reportportal.core.widget.util.WidgetFilterUtil;
import com.epam.ta.reportportal.dao.WidgetContentRepository;
import com.epam.ta.reportportal.entity.widget.WidgetOptions;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class LaunchesComparisonContentLoader
implements LoadContentStrategy {
    @Autowired
    private WidgetContentRepository widgetContentRepository;

    @Override
    public Map<String, ?> loadContent(List<String> contentFields, Map<Filter, Sort> filterSortMapping, WidgetOptions widgetOptions, int limit) {
        Filter filter = WidgetFilterUtil.GROUP_FILTERS.apply(filterSortMapping.keySet());
        Sort sort = Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"startTime"), Sort.Order.desc((String)"number")});
        List result = this.widgetContentRepository.launchesComparisonStatistics(filter, contentFields, sort, limit);
        if (result.isEmpty()) {
            return Collections.emptyMap();
        }
        Collections.reverse(result);
        return Collections.singletonMap("result", result);
    }
}

