/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.remover.user;

import com.epam.ta.reportportal.core.remover.ContentRemover;
import com.epam.ta.reportportal.dao.AttachmentRepository;
import com.epam.ta.reportportal.entity.attachment.Attachment;
import com.epam.ta.reportportal.entity.user.User;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserPhotoRemover
implements ContentRemover<User> {
    private static final String ATTACHMENT_CONTENT_TYPE = "attachmentContentType";
    private final AttachmentRepository attachmentRepository;

    @Autowired
    public UserPhotoRemover(AttachmentRepository attachmentRepository) {
        this.attachmentRepository = attachmentRepository;
    }

    @Override
    public void remove(User user) {
        Optional.ofNullable(user.getAttachment()).ifPresent(fileId -> {
            ArrayList<Long> attachmentsIds = new ArrayList<Long>(2);
            attachmentsIds.add(this.prepareAttachmentAndGetId((String)fileId));
            Optional.ofNullable(user.getAttachmentThumbnail()).ifPresent(thumbnailId -> attachmentsIds.add(this.prepareAttachmentAndGetId((String)thumbnailId)));
            Optional.ofNullable(user.getMetadata()).ifPresent(metadata -> metadata.getMetadata().remove(ATTACHMENT_CONTENT_TYPE));
            this.attachmentRepository.moveForDeletion(attachmentsIds);
        });
    }

    private Long prepareAttachmentAndGetId(String fileId) {
        Attachment attachment = new Attachment();
        attachment.setFileId(fileId);
        attachment.setCreationDate(Instant.now());
        return ((Attachment)this.attachmentRepository.save((Object)attachment)).getId();
    }
}

