/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.remover.project;

import com.epam.ta.reportportal.core.remover.ContentRemover;
import com.epam.ta.reportportal.core.widget.content.remover.WidgetContentRemover;
import com.epam.ta.reportportal.dao.WidgetRepository;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.entity.widget.WidgetType;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ProjectWidgetRemover
implements ContentRemover<Project> {
    private final WidgetRepository widgetRepository;
    private final WidgetContentRemover widgetContentRemover;

    @Autowired
    public ProjectWidgetRemover(WidgetRepository widgetRepository, @Qualifier(value="delegatingStateContentRemover") WidgetContentRemover widgetContentRemover) {
        this.widgetRepository = widgetRepository;
        this.widgetContentRemover = widgetContentRemover;
    }

    @Override
    public void remove(Project project) {
        List widgets = this.widgetRepository.findAllByProjectIdAndWidgetTypeIn(project.getId(), Collections.singletonList(WidgetType.COMPONENT_HEALTH_CHECK_TABLE.getType()));
        widgets.forEach(this.widgetContentRemover::removeContent);
    }
}

