/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.project.validator.notification;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.commons.validation.Suppliers;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.dao.SenderCaseRepository;
import com.epam.ta.reportportal.entity.enums.SendCase;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.model.project.email.SenderCaseDTO;
import com.epam.ta.reportportal.util.email.EmailRulesValidator;
import com.epam.ta.reportportal.ws.converter.converters.NotificationConfigConverter;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProjectNotificationValidator {
    private final SenderCaseRepository senderCaseRepository;

    @Autowired
    public ProjectNotificationValidator(SenderCaseRepository senderCaseRepository) {
        this.senderCaseRepository = senderCaseRepository;
    }

    public void validateCreateRQ(Project project, SenderCaseDTO senderCaseDTO) {
        this.validateSenderCase(project, senderCaseDTO);
        Optional<SenderCaseDTO> duplicate = this.senderCaseRepository.findAllByProjectId(project.getId()).stream().map(NotificationConfigConverter.TO_CASE_RESOURCE).filter(existing -> this.equalsWithoutRuleName((SenderCaseDTO)existing, senderCaseDTO)).findFirst();
        BusinessRule.expect(duplicate, Optional::isEmpty).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Project notification settings contain duplicate cases for this communication channel"});
    }

    public void validateUpdateRQ(Project project, SenderCaseDTO senderCaseDTO) {
        this.validateSenderCase(project, senderCaseDTO);
        Optional<SenderCaseDTO> duplicate = this.senderCaseRepository.findAllByProjectId(project.getId()).stream().filter(senderCase -> !Objects.equals(senderCase.getId(), senderCaseDTO.getId())).map(NotificationConfigConverter.TO_CASE_RESOURCE).filter(o1 -> this.equalsWithoutRuleName((SenderCaseDTO)o1, senderCaseDTO)).findFirst();
        BusinessRule.expect(duplicate, Optional::isEmpty).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Project notification settings contain duplicate cases for this communication channel"});
    }

    private void validateSenderCase(Project project, SenderCaseDTO senderCaseDTO) {
        BusinessRule.expect((Object)senderCaseDTO.getType(), Objects::nonNull).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Notification type"});
        if (senderCaseDTO.getType().equals("email")) {
            this.validateRecipients(senderCaseDTO);
        }
        this.normalizeCreateNotificationRQ(project, senderCaseDTO);
    }

    private void validateRecipients(SenderCaseDTO senderCaseDTO) {
        List<String> recipients = senderCaseDTO.getRecipients();
        BusinessRule.expect((Object)SendCase.findByName((String)senderCaseDTO.getSendCase()), Optional::isPresent).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{senderCaseDTO.getSendCase()});
        BusinessRule.expect(recipients, (Predicate)Predicates.notNull()).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Recipients list should not be null"});
        BusinessRule.expect((Object)recipients.isEmpty(), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Empty recipients list for email case '{}' ", (Object[])new Object[]{senderCaseDTO})});
    }

    private void normalizeCreateNotificationRQ(Project project, SenderCaseDTO createNotificationRQ) {
        Optional.ofNullable(createNotificationRQ.getRecipients()).ifPresent(recipients -> createNotificationRQ.setRecipients(createNotificationRQ.getRecipients().stream().map(recipient -> {
            EmailRulesValidator.validateRecipient(project, recipient);
            return recipient.trim();
        }).distinct().collect(Collectors.toList())));
        Optional.ofNullable(createNotificationRQ.getLaunchNames()).ifPresent(launchNames -> createNotificationRQ.setLaunchNames(launchNames.stream().map(name -> {
            EmailRulesValidator.validateLaunchName(name);
            return name.trim();
        }).distinct().collect(Collectors.toList())));
        Optional.ofNullable(createNotificationRQ.getAttributes()).ifPresent(attributes -> createNotificationRQ.setAttributes(attributes.stream().peek(attribute -> {
            EmailRulesValidator.validateLaunchAttribute(attribute);
            attribute.setValue(attribute.getValue().trim());
        }).collect(Collectors.toSet())));
    }

    private boolean equalsWithoutRuleName(SenderCaseDTO senderCase, SenderCaseDTO toCompare) {
        boolean recipientsEqual = !senderCase.getType().equals("email") || !toCompare.getType().equals("email") || senderCase.getRecipients() != null && toCompare.getRecipients() != null && CollectionUtils.isEqualCollection(senderCase.getRecipients(), toCompare.getRecipients());
        return recipientsEqual && Objects.equals(senderCase.getSendCase(), toCompare.getSendCase()) && CollectionUtils.isEqualCollection(senderCase.getLaunchNames(), toCompare.getLaunchNames()) && Objects.equals(senderCase.getType(), toCompare.getType()) && Objects.equals(senderCase.getRuleDetails(), toCompare.getRuleDetails()) && CollectionUtils.isEqualCollection(senderCase.getAttributes(), toCompare.getAttributes()) && Objects.equals(senderCase.getAttributesOperator(), toCompare.getAttributesOperator());
    }
}

