/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.project.validator.attribute;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.core.project.validator.attribute.DelayBoundValidator;
import com.epam.ta.reportportal.entity.AnalyzeMode;
import com.epam.ta.reportportal.entity.enums.ProjectAttributeEnum;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;

public class ProjectAttributeValidator {
    private static String NOTIFICATION_ATTRIBUTE_PATTERN = "notifications.\\w+.enabled";
    private final DelayBoundValidator delayBoundValidator;

    public ProjectAttributeValidator(DelayBoundValidator delayBoundValidator) {
        this.delayBoundValidator = delayBoundValidator;
    }

    public void verifyProjectAttributes(Map<String, String> currentAttributes, Map<String, String> newAttributes) {
        Set incompatibleAttributes = newAttributes.keySet().stream().filter(it -> !ProjectAttributeEnum.isPresent((String)it) && !it.matches(NOTIFICATION_ATTRIBUTE_PATTERN)).collect(Collectors.toSet());
        BusinessRule.expect(incompatibleAttributes, Set::isEmpty).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{incompatibleAttributes});
        Optional.ofNullable(newAttributes.get(ProjectAttributeEnum.AUTO_ANALYZER_MODE.getAttribute())).ifPresent(analyzerMode -> BusinessRule.expect((Object)AnalyzeMode.fromString((String)analyzerMode), (Predicate)Predicates.isPresent()).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{analyzerMode}));
        Optional.ofNullable(newAttributes.get(ProjectAttributeEnum.SEARCH_LOGS_MIN_SHOULD_MATCH.getAttribute())).ifPresent(attr -> BusinessRule.expect((Object)this.validatePercentage((String)attr), BooleanUtils::isTrue).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{ProjectAttributeEnum.SEARCH_LOGS_MIN_SHOULD_MATCH}));
        Map<ProjectAttributeEnum, Long> delays = this.validateDelays(newAttributes, List.of(ProjectAttributeEnum.KEEP_SCREENSHOTS, ProjectAttributeEnum.KEEP_LOGS, ProjectAttributeEnum.KEEP_LAUNCHES, ProjectAttributeEnum.INTERRUPT_JOB_TIME));
        this.delayBoundValidator.validate(currentAttributes, delays);
    }

    private Map<ProjectAttributeEnum, Long> validateDelays(Map<String, String> attributes, List<ProjectAttributeEnum> projectAttributes) {
        return projectAttributes.stream().filter(it -> attributes.containsKey(it.getAttribute())).collect(Collectors.toMap(a -> a, a -> this.getDelay((String)attributes.get(a.getAttribute()))));
    }

    private Long getDelay(String value) {
        Long delay = "0".equals(value) ? Long.MAX_VALUE : this.getLong(value);
        BusinessRule.expect((Object)delay, d -> d >= 0L).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Delay attribute value should be greater than 0"});
        return delay;
    }

    private boolean validatePercentage(String value) {
        int percent = this.getInt(value);
        return percent >= 0 && percent <= 100;
    }

    private Long getLong(String value) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException exc) {
            throw new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{exc.getMessage()});
        }
    }

    private Integer getInt(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException exc) {
            throw new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{exc.getMessage()});
        }
    }
}

