/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.project.validator.attribute;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.commons.validation.Suppliers;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.core.project.validator.attribute.DelayBoundLessRule;
import com.epam.ta.reportportal.entity.enums.ProjectAttributeEnum;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class DelayBoundValidator {
    private final List<DelayBoundLessRule> rules;

    public DelayBoundValidator(List<DelayBoundLessRule> rules) {
        this.rules = rules;
    }

    public void validate(Map<String, String> currentAttributes, Map<ProjectAttributeEnum, Long> newAttributes) {
        this.rules.forEach(rule -> {
            Long lowerDelay = Optional.ofNullable((Long)newAttributes.get(rule.getLower())).orElseGet(() -> this.getCurrentDelay(currentAttributes, rule.getLower()));
            Long higherDelay = Optional.ofNullable((Long)newAttributes.get(rule.getHigher())).orElseGet(() -> this.getCurrentDelay(currentAttributes, rule.getHigher()));
            BusinessRule.expect((Object)(lowerDelay <= higherDelay ? 1 : 0), (Predicate)Predicates.equalTo((Object)Boolean.TRUE)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Delay of '{}' should not be higher than '{}'", (Object[])new Object[]{rule.getLower().getAttribute(), rule.getHigher().getAttribute()}).toString()});
        });
    }

    private Long getCurrentDelay(Map<String, String> currentAttributes, ProjectAttributeEnum attribute) {
        return Optional.ofNullable(currentAttributes.get(attribute.getAttribute())).map(this::resolveDelay).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Attribute - {} was not found", (Supplier[])new Supplier[0]), attribute.getAttribute()}));
    }

    private Long resolveDelay(String value) {
        try {
            return "0".equals(value) ? Long.MAX_VALUE : Long.parseLong(value);
        }
        catch (NumberFormatException exc) {
            throw new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{exc.getMessage()});
        }
    }
}

