/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.project.settings.notification;

import com.epam.ta.reportportal.core.project.settings.notification.ProjectRecipientHandler;
import com.epam.ta.reportportal.dao.SenderCaseRepository;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.entity.user.User;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RecipientRemover
implements ProjectRecipientHandler {
    private final SenderCaseRepository senderCaseRepository;

    @Autowired
    public RecipientRemover(SenderCaseRepository senderCaseRepository) {
        this.senderCaseRepository = senderCaseRepository;
    }

    @Override
    public void handle(Iterable<User> users, Project project) {
        Set toExclude = StreamSupport.stream(users.spliterator(), false).map(user -> Arrays.asList(user.getEmail().toLowerCase(), user.getLogin().toLowerCase())).flatMap(Collection::stream).collect(Collectors.toSet());
        this.senderCaseRepository.findAllByProjectId(project.getId()).forEach(senderCase -> this.senderCaseRepository.deleteRecipients(senderCase.getId(), (Collection)toExclude));
    }
}

