/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.project.settings.notification;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.commons.validation.Suppliers;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.NotificationsConfigUpdatedEvent;
import com.epam.ta.reportportal.core.project.settings.notification.DeleteProjectNotificationHandler;
import com.epam.ta.reportportal.dao.SenderCaseRepository;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.model.project.ProjectResource;
import com.epam.ta.reportportal.model.project.email.ProjectNotificationConfigDTO;
import com.epam.ta.reportportal.ws.converter.converters.ProjectConverter;
import com.epam.ta.reportportal.ws.reporting.OperationCompletionRS;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class DeleteProjectNotificationHandlerImpl
implements DeleteProjectNotificationHandler {
    private final SenderCaseRepository senderCaseRepository;
    private final MessageBus messageBus;
    private final ProjectConverter projectConverter;

    public DeleteProjectNotificationHandlerImpl(SenderCaseRepository senderCaseRepository, MessageBus messageBus, ProjectConverter projectConverter) {
        this.senderCaseRepository = senderCaseRepository;
        this.messageBus = messageBus;
        this.projectConverter = projectConverter;
    }

    @Override
    public OperationCompletionRS deleteNotification(Project project, Long notificationId, ReportPortalUser user) {
        Optional senderCase = this.senderCaseRepository.findById((Object)notificationId);
        BusinessRule.expect((Object)senderCase, notification -> notification.map(ntf -> Objects.equals(ntf.getProject().getId(), project.getId())).orElse(false)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Notification '{}' not found. Did you use correct Notification ID?", (Object[])new Object[]{notificationId}).get()});
        ProjectResource projectResource = this.projectConverter.TO_PROJECT_RESOURCE.apply(project);
        ProjectNotificationConfigDTO projectNotificationConfigDTO = projectResource.getConfiguration().getProjectConfig();
        Optional.ofNullable(projectNotificationConfigDTO.getSenderCases()).ifPresent(scs -> projectNotificationConfigDTO.setSenderCases(scs.stream().filter(sc -> !Objects.equals(sc.getId(), notificationId)).collect(Collectors.toList())));
        project.getSenderCases().removeIf(sc -> sc.getId().equals(notificationId));
        this.messageBus.publishActivity(new NotificationsConfigUpdatedEvent(projectResource, projectResource.getConfiguration().getProjectConfig(), user.getUserId(), user.getUsername()));
        return new OperationCompletionRS("Notification rule was deleted successfully.");
    }
}

