/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.project.settings.notification;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.NotificationsConfigUpdatedEvent;
import com.epam.ta.reportportal.core.project.settings.notification.CreateProjectNotificationHandler;
import com.epam.ta.reportportal.core.project.validator.notification.ProjectNotificationValidator;
import com.epam.ta.reportportal.dao.SenderCaseRepository;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.entity.project.email.SenderCase;
import com.epam.ta.reportportal.entity.project.email.SenderCaseOptions;
import com.epam.ta.reportportal.model.EntryCreatedRS;
import com.epam.ta.reportportal.model.project.ProjectResource;
import com.epam.ta.reportportal.model.project.email.ProjectNotificationConfigDTO;
import com.epam.ta.reportportal.model.project.email.SenderCaseDTO;
import com.epam.ta.reportportal.ws.converter.converters.NotificationConfigConverter;
import com.epam.ta.reportportal.ws.converter.converters.ProjectConverter;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class CreateProjectNotificationHandlerImpl
implements CreateProjectNotificationHandler {
    private final SenderCaseRepository senderCaseRepository;
    private final MessageBus messageBus;
    private final ProjectConverter projectConverter;
    private final ProjectNotificationValidator projectNotificationValidator;

    public CreateProjectNotificationHandlerImpl(SenderCaseRepository senderCaseRepository, MessageBus messageBus, ProjectConverter projectConverter, ProjectNotificationValidator projectNotificationValidator) {
        this.senderCaseRepository = senderCaseRepository;
        this.messageBus = messageBus;
        this.projectConverter = projectConverter;
        this.projectNotificationValidator = projectNotificationValidator;
    }

    @Override
    public EntryCreatedRS createNotification(Project project, SenderCaseDTO createNotificationRQ, ReportPortalUser user) {
        BusinessRule.expect((Object)this.senderCaseRepository.findByProjectIdAndTypeAndRuleNameIgnoreCase(project.getId(), createNotificationRQ.getType(), createNotificationRQ.getRuleName()), Optional::isEmpty).verify(ErrorType.RESOURCE_ALREADY_EXISTS, new Object[]{createNotificationRQ.getRuleName()});
        this.projectNotificationValidator.validateCreateRQ(project, createNotificationRQ);
        SenderCase senderCase = NotificationConfigConverter.TO_CASE_MODEL.apply(createNotificationRQ);
        senderCase.setId(null);
        senderCase.setProject(project);
        senderCase.setType(createNotificationRQ.getType());
        Optional.ofNullable(createNotificationRQ.getRuleDetails()).map(SenderCaseOptions::new).ifPresent(arg_0 -> ((SenderCase)senderCase).setRuleDetails(arg_0));
        this.senderCaseRepository.save((Object)senderCase);
        ProjectResource projectResource = this.projectConverter.TO_PROJECT_RESOURCE.apply(project);
        ProjectNotificationConfigDTO projectNotificationConfigDTO = projectResource.getConfiguration().getProjectConfig();
        projectNotificationConfigDTO.getSenderCases().add(createNotificationRQ);
        this.messageBus.publishActivity(new NotificationsConfigUpdatedEvent(projectResource, projectResource.getConfiguration().getProjectConfig(), user.getUserId(), user.getUsername()));
        return new EntryCreatedRS(senderCase.getId());
    }
}

