/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.project.settings.impl;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.commons.validation.Suppliers;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.DefectTypeDeletedEvent;
import com.epam.ta.reportportal.core.events.activity.PatternDeletedEvent;
import com.epam.ta.reportportal.core.project.settings.DeleteProjectSettingsHandler;
import com.epam.ta.reportportal.dao.IssueEntityRepository;
import com.epam.ta.reportportal.dao.IssueTypeRepository;
import com.epam.ta.reportportal.dao.PatternTemplateRepository;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.dao.StatisticsFieldRepository;
import com.epam.ta.reportportal.dao.WidgetRepository;
import com.epam.ta.reportportal.entity.enums.TestItemIssueGroup;
import com.epam.ta.reportportal.entity.item.issue.IssueType;
import com.epam.ta.reportportal.entity.pattern.PatternTemplate;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.entity.project.ProjectIssueType;
import com.epam.ta.reportportal.entity.widget.WidgetType;
import com.epam.ta.reportportal.model.activity.PatternTemplateActivityResource;
import com.epam.ta.reportportal.ws.converter.converters.IssueTypeConverter;
import com.epam.ta.reportportal.ws.converter.converters.PatternTemplateConverter;
import com.epam.ta.reportportal.ws.reporting.OperationCompletionRS;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DeleteProjectSettingsHandlerImpl
implements DeleteProjectSettingsHandler {
    private final ProjectRepository projectRepository;
    private final StatisticsFieldRepository statisticsFieldRepository;
    private final WidgetRepository widgetRepository;
    private final MessageBus messageBus;
    private final IssueTypeRepository issueTypeRepository;
    private final IssueEntityRepository issueEntityRepository;
    private final PatternTemplateRepository patternTemplateRepository;
    private final ApplicationEventPublisher eventPublisher;

    @Autowired
    public DeleteProjectSettingsHandlerImpl(ProjectRepository projectRepository, StatisticsFieldRepository statisticsFieldRepository, WidgetRepository widgetRepository, MessageBus messageBus, IssueTypeRepository issueTypeRepository, IssueEntityRepository issueEntityRepository, PatternTemplateRepository patternTemplateRepository, ApplicationEventPublisher eventPublisher) {
        this.projectRepository = projectRepository;
        this.statisticsFieldRepository = statisticsFieldRepository;
        this.widgetRepository = widgetRepository;
        this.messageBus = messageBus;
        this.issueTypeRepository = issueTypeRepository;
        this.issueEntityRepository = issueEntityRepository;
        this.patternTemplateRepository = patternTemplateRepository;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public OperationCompletionRS deleteProjectIssueSubType(String projectName, ReportPortalUser user, Long id) {
        Project project = (Project)this.projectRepository.findByName(projectName).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName}));
        ProjectIssueType type = project.getProjectIssueTypes().stream().filter(projectIssueType -> projectIssueType.getIssueType().getId().equals(id)).findFirst().orElseThrow(() -> new ReportPortalException(ErrorType.ISSUE_TYPE_NOT_FOUND, new Object[]{id}));
        BusinessRule.expect((Object)type.getIssueType().getLocator(), (Predicate)Predicates.not((Predicate)Predicates.in((Collection)Sets.newHashSet((Object[])new String[]{TestItemIssueGroup.AUTOMATION_BUG.getLocator(), TestItemIssueGroup.PRODUCT_BUG.getLocator(), TestItemIssueGroup.SYSTEM_ISSUE.getLocator(), TestItemIssueGroup.NO_DEFECT.getLocator(), TestItemIssueGroup.TO_INVESTIGATE.getLocator()})))).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{"You cannot remove predefined global issue types."});
        String issueField = "statistics$defects$" + ((TestItemIssueGroup)TestItemIssueGroup.fromValue((String)type.getIssueType().getIssueGroup().getTestItemIssueGroup().getValue()).orElseThrow(() -> new ReportPortalException(ErrorType.ISSUE_TYPE_NOT_FOUND, new Object[]{type.getIssueType().getIssueGroup()}))).getValue().toLowerCase() + "$" + type.getIssueType().getLocator();
        this.statisticsFieldRepository.deleteByName(issueField);
        IssueType defaultGroupIssueType = (IssueType)this.issueTypeRepository.findByLocator(type.getIssueType().getIssueGroup().getTestItemIssueGroup().getLocator()).orElseThrow(() -> new ReportPortalException(ErrorType.ISSUE_TYPE_NOT_FOUND, new Object[]{type.getIssueType()}));
        List allByIssueTypeId = this.issueEntityRepository.findAllByIssueTypeId(id);
        allByIssueTypeId.forEach(issueEntity -> issueEntity.setIssueType(defaultGroupIssueType));
        project.getProjectIssueTypes().remove(type);
        this.projectRepository.save((Object)project);
        this.updateWidgets(project, type.getIssueType());
        this.issueTypeRepository.delete((Object)type.getIssueType());
        DefectTypeDeletedEvent defectTypeDeletedEvent = new DefectTypeDeletedEvent(IssueTypeConverter.TO_ACTIVITY_RESOURCE.apply(type.getIssueType()), user.getUserId(), user.getUsername(), project.getId());
        this.eventPublisher.publishEvent((Object)defectTypeDeletedEvent);
        return new OperationCompletionRS("Issue sub-type delete operation completed successfully.");
    }

    private void updateWidgets(Project project, IssueType issueType) {
        String contentField = "statistics$defects$" + issueType.getIssueGroup().getTestItemIssueGroup().getValue().toLowerCase() + "$" + issueType.getLocator();
        this.widgetRepository.findAllByProjectIdAndWidgetTypeInAndContentFieldsContains(project.getId(), Arrays.stream(WidgetType.values()).filter(WidgetType::isIssueTypeUpdateSupported).map(WidgetType::getType).collect(Collectors.toList()), contentField).forEach(widget -> widget.getContentFields().remove(contentField));
    }

    @Override
    public OperationCompletionRS deletePatternTemplate(String projectName, ReportPortalUser user, Long id) {
        Project project = (Project)this.projectRepository.findByName(projectName).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName}));
        PatternTemplate patternTemplate = (PatternTemplate)this.patternTemplateRepository.findByIdAndProjectId(id, project.getId()).orElseThrow(() -> new ReportPortalException(ErrorType.PATTERN_TEMPLATE_NOT_FOUND_IN_PROJECT, new Object[]{id, project.getName()}));
        PatternTemplateActivityResource before = PatternTemplateConverter.TO_ACTIVITY_RESOURCE.apply(patternTemplate);
        project.getPatternTemplates().removeIf(pt -> pt.getId().equals(id));
        this.messageBus.publishActivity(new PatternDeletedEvent(user.getUserId(), user.getUsername(), before));
        return new OperationCompletionRS((String)Suppliers.formattedSupplier((String)"Pattern template with id = '{}' has been successfully removed.", (Object[])new Object[]{id}).get());
    }
}

