/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.project.impl;

import com.epam.reportportal.extension.event.ProjectEvent;
import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.commons.validation.Suppliers;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.events.activity.ProjectCreatedEvent;
import com.epam.ta.reportportal.core.project.CreateProjectHandler;
import com.epam.ta.reportportal.dao.AttributeRepository;
import com.epam.ta.reportportal.dao.IssueTypeRepository;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.dao.ProjectUserRepository;
import com.epam.ta.reportportal.dao.UserRepository;
import com.epam.ta.reportportal.entity.enums.ProjectType;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.entity.project.ProjectRole;
import com.epam.ta.reportportal.entity.project.ProjectUtils;
import com.epam.ta.reportportal.entity.user.ProjectUser;
import com.epam.ta.reportportal.entity.user.User;
import com.epam.ta.reportportal.model.EntryCreatedRS;
import com.epam.ta.reportportal.model.project.CreateProjectRQ;
import com.epam.ta.reportportal.util.PersonalProjectService;
import com.epam.ta.reportportal.util.Predicates;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public class CreateProjectHandlerImpl
implements CreateProjectHandler {
    private static final String CREATE_KEY = "create";
    private static final String RESERVED_PROJECT_NAME = "project";
    private final PersonalProjectService personalProjectService;
    private final ProjectRepository projectRepository;
    private final UserRepository userRepository;
    private final AttributeRepository attributeRepository;
    private final IssueTypeRepository issueTypeRepository;
    private final ApplicationEventPublisher applicationEventPublisher;
    private final ProjectUserRepository projectUserRepository;

    @Autowired
    public CreateProjectHandlerImpl(PersonalProjectService personalProjectService, ProjectRepository projectRepository, UserRepository userRepository, AttributeRepository attributeRepository, IssueTypeRepository issueTypeRepository, ApplicationEventPublisher applicationEventPublisher, ProjectUserRepository projectUserRepository) {
        this.personalProjectService = personalProjectService;
        this.projectRepository = projectRepository;
        this.userRepository = userRepository;
        this.attributeRepository = attributeRepository;
        this.issueTypeRepository = issueTypeRepository;
        this.applicationEventPublisher = applicationEventPublisher;
        this.projectUserRepository = projectUserRepository;
    }

    @Override
    public EntryCreatedRS createProject(CreateProjectRQ createProjectRQ, ReportPortalUser user) {
        String projectName = createProjectRQ.getProjectName().toLowerCase().trim();
        BusinessRule.expect((Object)projectName, (Predicate)com.epam.ta.reportportal.commons.Predicates.not((Predicate)com.epam.ta.reportportal.commons.Predicates.equalTo((Object)RESERVED_PROJECT_NAME))).verify(ErrorType.INCORRECT_REQUEST, new Object[]{Suppliers.formattedSupplier((String)"Project with name '{}' is reserved by system", (Object[])new Object[]{projectName})});
        BusinessRule.expect((Object)projectName, Predicates.SPECIAL_CHARS_ONLY.negate()).verify(ErrorType.INCORRECT_REQUEST, new Object[]{Suppliers.formattedSupplier((String)"Project name '{}' consists only of special characters", (Object[])new Object[]{projectName})});
        Optional existProject = this.projectRepository.findByName(projectName);
        BusinessRule.expect((Object)existProject, (Predicate)com.epam.ta.reportportal.commons.Predicates.not((Predicate)com.epam.ta.reportportal.commons.Predicates.isPresent())).verify(ErrorType.PROJECT_ALREADY_EXISTS, new Object[]{projectName});
        ProjectType projectType = (ProjectType)ProjectType.findByName((String)createProjectRQ.getEntryType()).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{createProjectRQ.getEntryType()}));
        BusinessRule.expect((Object)projectType, (Predicate)com.epam.ta.reportportal.commons.Predicates.equalTo((Object)ProjectType.INTERNAL)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Only internal projects can be created via API"});
        User dbUser = (User)this.userRepository.findRawById(user.getUserId()).orElseThrow(() -> new ReportPortalException(ErrorType.USER_NOT_FOUND, new Object[]{user.getUsername()}));
        Project project = new Project();
        project.setName(projectName);
        project.setCreationDate(Instant.now());
        project.setProjectIssueTypes(ProjectUtils.defaultIssueTypes((Project)project, (List)this.issueTypeRepository.getDefaultIssueTypes()));
        Set projectAttributes = ProjectUtils.defaultProjectAttributes((Project)project, (Set)this.attributeRepository.getDefaultProjectAttributes());
        project.setProjectType(projectType);
        project.setProjectAttributes(projectAttributes);
        ProjectUser projectUser = new ProjectUser().withProject(project).withUser(dbUser).withProjectRole(ProjectRole.PROJECT_MANAGER);
        this.projectRepository.save((Object)project);
        this.projectUserRepository.save((Object)projectUser);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new ProjectEvent(project.getId(), CREATE_KEY));
        this.publishProjectCreatedEvent(user.getUserId(), user.getUsername(), project);
        return new EntryCreatedRS(project.getId());
    }

    private void publishProjectCreatedEvent(Long userId, String userLogin, Project project) {
        Long projectId = project.getId();
        String projectName = project.getName();
        ProjectCreatedEvent event = new ProjectCreatedEvent(userId, userLogin, projectId, projectName);
        this.applicationEventPublisher.publishEvent((Object)event);
    }

    @Override
    public Project createPersonal(User user) {
        Project personalProject = this.personalProjectService.generatePersonalProject(user);
        personalProject.getUsers().clear();
        this.projectRepository.save((Object)personalProject);
        this.publishProjectCreatedEvent(null, "ReportPortal", personalProject);
        return personalProject;
    }
}

