/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.onboarding;

import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.dao.OnboardingRepository;
import com.epam.ta.reportportal.entity.onboarding.Onboarding;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class OnboardingService {
    private final OnboardingRepository onboardingRepository;
    private final ObjectMapper objectMapper;

    public OnboardingService(OnboardingRepository onboardingRepository, ObjectMapper objectMapper) {
        this.onboardingRepository = onboardingRepository;
        this.objectMapper = objectMapper;
    }

    public Object getOnboardingDataForPageIfAvailable(String page) {
        Onboarding onboarding = this.onboardingRepository.findAvailableOnboardingByPage(page);
        try {
            return onboarding != null ? this.objectMapper.readValue(onboarding.getData(), (TypeReference)new TypeReference<List<Map<String, String>>>(this){}) : null;
        }
        catch (JsonProcessingException e) {
            throw new ReportPortalException(ErrorType.UNCLASSIFIED_ERROR, new Object[]{"Unable to parse onboarding data: " + e.getMessage()});
        }
    }
}

