/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.logging;

import com.epam.ta.reportportal.core.logging.RabbitMessageLogging;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.Payload;

@Aspect
public class RabbitMessageLoggingAspect {
    private static final String NEWLINE = "\n";
    private static final String BODY_DENOMINATOR = "-- Body --";
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private MessageConverter messageConverter;

    @Around(value="execution(public * *(..)) && @annotation(annotation)")
    public Object log(ProceedingJoinPoint joinPoint, RabbitMessageLogging annotation) throws Throwable {
        Logger logger = LoggerFactory.getLogger(joinPoint.getTarget().getClass());
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        HashMap<String, Object> headers = new HashMap<String, Object>();
        Object body = this.getHeadersAndBody(joinPoint, method, headers);
        String prefix = method.getName();
        if (logger.isDebugEnabled()) {
            logger.debug(this.formatMessageRecord(prefix, headers, body, annotation));
        }
        return joinPoint.proceed();
    }

    protected Object getHeadersAndBody(ProceedingJoinPoint joinPoint, Method method, Map<String, Object> headers) {
        Object body = null;
        Object[] args = joinPoint.getArgs();
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Object arg = args[i];
            if (arg == null) continue;
            if (arg instanceof Message) {
                Message message = (Message)arg;
                body = this.messageConverter.fromMessage(message);
                headers.putAll(message.getMessageProperties().getHeaders());
                break;
            }
            if (parameters[i].isAnnotationPresent(Payload.class)) {
                body = arg;
                continue;
            }
            if (!parameters[i].isAnnotationPresent(Header.class)) continue;
            headers.put(parameters[i].getAnnotation(Header.class).name(), arg);
        }
        return body;
    }

    protected String formatMessageRecord(String prefix, Map<String, Object> headers, Object body, RabbitMessageLogging annotation) throws Exception {
        StringBuilder record = new StringBuilder();
        record.append(prefix).append(" - Rabbit message");
        if (annotation.logHeaders()) {
            for (Map.Entry<String, Object> entry : headers.entrySet()) {
                record.append(NEWLINE).append(' ').append(entry.getKey()).append(": ").append(entry.getValue());
            }
        }
        if (annotation.logBody() && body != null) {
            try {
                record.append(NEWLINE).append(' ').append(BODY_DENOMINATOR).append(NEWLINE).append(' ').append(this.objectMapper.writeValueAsString(body));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
        return record.toString();
    }
}

