/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.log.impl;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.commons.validation.Suppliers;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.CompositeFilterCondition;
import com.epam.ta.reportportal.commons.querygen.Condition;
import com.epam.ta.reportportal.commons.querygen.ConvertibleCondition;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.FilterCondition;
import com.epam.ta.reportportal.commons.querygen.ProjectFilter;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.core.item.TestItemService;
import com.epam.ta.reportportal.core.log.GetLogHandler;
import com.epam.ta.reportportal.core.log.LogService;
import com.epam.ta.reportportal.core.log.impl.PagedLogResource;
import com.epam.ta.reportportal.dao.LogRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.enums.LogLevel;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.item.NestedItem;
import com.epam.ta.reportportal.entity.item.NestedStep;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.log.LogFull;
import com.epam.ta.reportportal.model.log.GetLogsUnderRq;
import com.epam.ta.reportportal.model.log.LogResource;
import com.epam.ta.reportportal.ws.converter.PagedResourcesAssembler;
import com.epam.ta.reportportal.ws.converter.converters.LogConverter;
import com.epam.ta.reportportal.ws.converter.converters.TestItemConverter;
import com.google.common.collect.Lists;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.BooleanUtils;
import org.jooq.Operator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.support.PageableExecutionUtils;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;

@Service
public class GetLogHandlerImpl
implements GetLogHandler {
    public static final String EXCLUDE_PASSED_LOGS = "excludePassedLogs";
    public static final String EXCLUDE_EMPTY_STEPS = "excludeEmptySteps";
    public static final String EXCLUDE_LOG_CONTENT = "excludeLogContent";
    private static final int NESTED_STEP_MAX_PAGE_SIZE = 300;
    private static final int LOG_UNDER_ITEM_BATCH_SIZE = 5;
    private final LogRepository logRepository;
    private final LogService logService;
    private final TestItemRepository testItemRepository;
    private final TestItemService testItemService;

    @Autowired
    public GetLogHandlerImpl(LogRepository logRepository, LogService logService, TestItemRepository testItemRepository, TestItemService testItemService) {
        this.logRepository = logRepository;
        this.logService = logService;
        this.testItemRepository = testItemRepository;
        this.testItemService = testItemService;
    }

    @Override
    public com.epam.ta.reportportal.model.Page<LogResource> getLogs(@Nullable String path, ReportPortalUser.ProjectDetails projectDetails, Filter filterable, Pageable pageable) {
        Optional.ofNullable(path).ifPresent(p -> this.updateFilter(filterable, (String)p));
        Page<LogFull> logFullPage = this.logService.findByFilter((Queryable)ProjectFilter.of((Queryable)filterable, (Long)projectDetails.getProjectId()), pageable);
        return PagedResourcesAssembler.pageConverter(LogConverter.TO_RESOURCE).apply(logFullPage);
    }

    @Override
    public Map<Long, List<LogResource>> getLogs(GetLogsUnderRq logsUnderRq, ReportPortalUser.ProjectDetails projectDetails) {
        LogLevel logLevel = (LogLevel)LogLevel.toLevel((String)logsUnderRq.getLogLevel()).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{logsUnderRq.getLogLevel()}));
        return this.testItemRepository.findAllById(logsUnderRq.getItemIds()).stream().collect(Collectors.toMap(TestItem::getItemId, item -> {
            Launch launch = this.testItemService.getEffectiveLaunch((TestItem)item);
            this.validate(launch, projectDetails);
            return this.logService.findLatestUnderTestItemByLaunchIdAndTestItemIdsAndLogLevelGte(launch.getId(), item.getItemId(), logLevel.toInt(), 5).stream().map(LogConverter.TO_RESOURCE).collect(Collectors.toList());
        }));
    }

    @Override
    public long getPageNumber(Long logId, ReportPortalUser.ProjectDetails projectDetails, Filter filterable, Pageable pageable) {
        return this.logRepository.getPageNumber(logId, filterable, pageable).intValue();
    }

    @Override
    public LogResource getLog(String logId, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        LogFull logFull;
        try {
            logFull = this.findById(Long.parseLong(logId));
        }
        catch (NumberFormatException e) {
            logFull = this.findByUuid(logId);
        }
        this.validate(logFull, projectDetails);
        return LogConverter.TO_RESOURCE.apply(logFull);
    }

    @Override
    public com.epam.ta.reportportal.model.Page<?> getNestedItems(Long parentId, ReportPortalUser.ProjectDetails projectDetails, Map<String, String> params, Queryable queryable, Pageable pageable) {
        TestItem parentItem = (TestItem)this.testItemRepository.findById((Object)parentId).orElseThrow(() -> new ReportPortalException(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{parentId}));
        Launch launch = this.testItemService.getEffectiveLaunch(parentItem);
        this.validate(launch, projectDetails);
        Boolean excludeEmptySteps = Optional.ofNullable(params.get(EXCLUDE_EMPTY_STEPS)).map(BooleanUtils::toBoolean).orElse(false);
        Boolean excludePassedLogs = Optional.ofNullable(params.get(EXCLUDE_PASSED_LOGS)).map(BooleanUtils::toBoolean).orElse(false);
        Page nestedItems = this.logRepository.findNestedItems(parentId, excludeEmptySteps.booleanValue(), this.isLogsExclusionRequired(parentItem, excludePassedLogs), queryable, pageable);
        List content = nestedItems.getContent();
        Map<String, List<NestedItem>> result = content.stream().collect(Collectors.groupingBy(NestedItem::getType));
        Map logMap = Optional.ofNullable(result.get("log")).map(logs -> this.logService.findAllById(logs.stream().map(NestedItem::getId).collect(Collectors.toSet())).stream().collect(Collectors.toMap(LogFull::getId, l -> l))).orElseGet(Collections::emptyMap);
        queryable.getFilterConditions().add(this.getLaunchCondition(launch.getId()));
        queryable.getFilterConditions().add(this.getParentPathCondition(parentItem));
        Map nestedStepMap = Optional.ofNullable(result.get("item")).map(testItems -> this.testItemRepository.findAllNestedStepsByIds((Collection)testItems.stream().map(NestedItem::getId).collect(Collectors.toSet()), queryable, excludePassedLogs.booleanValue()).stream().collect(Collectors.toMap(NestedStep::getId, i -> i))).orElseGet(Collections::emptyMap);
        ArrayList resources = Lists.newArrayListWithExpectedSize((int)content.size());
        content.forEach(nestedItem -> {
            if ("log".equals(nestedItem.getType())) {
                Optional.ofNullable((LogFull)logMap.get(nestedItem.getId())).map(LogConverter.TO_RESOURCE).ifPresent(resources::add);
            } else if ("item".equals(nestedItem.getType())) {
                Optional.ofNullable((NestedStep)nestedStepMap.get(nestedItem.getId())).map(TestItemConverter.TO_NESTED_STEP_RESOURCE).ifPresent(resources::add);
            }
        });
        return PagedResourcesAssembler.pageConverter().apply(PageableExecutionUtils.getPage((List)resources, (Pageable)nestedItems.getPageable(), () -> ((Page)nestedItems).getTotalElements()));
    }

    @Override
    public List<PagedLogResource> getLogsWithLocation(Long parentId, ReportPortalUser.ProjectDetails projectDetails, Map<String, String> params, Queryable queryable, Pageable pageable) {
        TestItem parentItem = (TestItem)this.testItemRepository.findById((Object)parentId).orElseThrow(() -> new ReportPortalException(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{parentId}));
        Launch launch = this.testItemService.getEffectiveLaunch(parentItem);
        this.validate(launch, projectDetails);
        Boolean excludeEmptySteps = Optional.ofNullable(params.get(EXCLUDE_EMPTY_STEPS)).map(BooleanUtils::toBoolean).orElse(false);
        Boolean excludePassedLogs = Optional.ofNullable(params.get(EXCLUDE_PASSED_LOGS)).map(BooleanUtils::toBoolean).orElse(false);
        Boolean excludeLogContent = Optional.ofNullable(params.get(EXCLUDE_LOG_CONTENT)).map(BooleanUtils::toBoolean).orElse(false);
        LinkedList<PagedLogResource> loadedLogs = new LinkedList<PagedLogResource>();
        this.loadInnerLogs(parentId, loadedLogs, Collections.emptyList(), excludeEmptySteps, excludePassedLogs, queryable, pageable);
        if (!excludeLogContent.booleanValue()) {
            Map<Long, LogFull> logMap = this.logService.findAllById(loadedLogs.stream().map(LogResource::getId).collect(Collectors.toSet())).stream().collect(Collectors.toMap(LogFull::getId, l -> l));
            loadedLogs.forEach(resource -> {
                LogFull model = (LogFull)logMap.get(resource.getId());
                LogConverter.FILL_WITH_LOG_CONTENT.apply(model, (PagedLogResource)resource);
            });
        }
        return loadedLogs;
    }

    private void loadInnerLogs(Long parentId, List<PagedLogResource> results, List<Map.Entry<Long, Integer>> pagesLocation, boolean excludeEmptySteps, boolean excludePassedLogs, Queryable queryable, Pageable pageable) {
        TestItem parentItem = (TestItem)this.testItemRepository.findById((Object)parentId).orElseThrow(() -> new ReportPortalException(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{parentId}));
        if (this.isLogsExclusionRequired(parentItem, excludePassedLogs)) {
            return;
        }
        List nestedItems = this.logRepository.findNestedItemsWithPage(parentId, excludeEmptySteps, this.isLogsExclusionRequired(parentItem, excludePassedLogs), queryable, pageable);
        nestedItems.stream().filter(nestedItem -> nestedItem.getType().equals("item") || nestedItem.getLogLevel() >= 40000).forEach(nestedItem -> {
            LinkedList<Map.Entry<Long, Integer>> copy = new LinkedList<Map.Entry<Long, Integer>>(pagesLocation);
            copy.add(new AbstractMap.SimpleEntry<Long, Integer>(nestedItem.getId(), nestedItem.getPageNumber()));
            if (nestedItem.getType().equals("item")) {
                this.loadInnerLogs(nestedItem.getId(), results, copy, excludeEmptySteps, excludePassedLogs, queryable, (Pageable)PageRequest.of((int)1, (int)300, (Sort)pageable.getSort()));
            } else {
                PagedLogResource pagedLogResource = new PagedLogResource();
                pagedLogResource.setId(nestedItem.getId());
                pagedLogResource.setPagesLocation(copy);
                results.add(pagedLogResource);
            }
        });
    }

    private void validate(LogFull log, ReportPortalUser.ProjectDetails projectDetails) {
        Long launchProjectId = Optional.ofNullable(log.getTestItem()).map(it -> this.testItemService.getEffectiveLaunch((TestItem)it).getProjectId()).orElseGet(() -> log.getLaunch().getProjectId());
        BusinessRule.expect((Object)launchProjectId, (Predicate)Predicates.equalTo((Object)projectDetails.getProjectId())).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{Suppliers.formattedSupplier((String)"Log '{}' is not under '{}' project", (Object[])new Object[]{log.getId(), projectDetails.getProjectName()})});
    }

    private void validate(Launch launch, ReportPortalUser.ProjectDetails projectDetails) {
        BusinessRule.expect((Object)launch.getProjectId(), (Predicate)Predicates.equalTo((Object)projectDetails.getProjectId())).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{Suppliers.formattedSupplier((String)"Launch '{}' is not under '{}' project", (Object[])new Object[]{launch.getId(), projectDetails.getProjectName()})});
    }

    private LogFull findById(Long logId) {
        return this.logService.findById(logId).orElseThrow(() -> new ReportPortalException(ErrorType.LOG_NOT_FOUND, new Object[]{logId}));
    }

    private LogFull findByUuid(String logId) {
        return this.logService.findByUuid(logId).orElseThrow(() -> new ReportPortalException(ErrorType.LOG_NOT_FOUND, new Object[]{logId}));
    }

    private FilterCondition getLaunchCondition(Long launchId) {
        return FilterCondition.builder().eq("launchId", String.valueOf(launchId)).build();
    }

    private void updateFilter(Filter filterable, String path) {
        TestItem testItem = (TestItem)this.testItemRepository.findByPath(path).orElseThrow(() -> new ReportPortalException(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{path}));
        this.updatePathCondition(testItem, filterable);
        Launch launch = this.testItemService.getEffectiveLaunch(testItem);
        FilterCondition.ConditionBuilder itemLaunchIdConditionBuilder = FilterCondition.builder().eq("launchId", String.valueOf(launch.getId()));
        ConvertibleCondition launchIdCondition = Optional.ofNullable(testItem.getRetryOf()).map(retryOf -> new CompositeFilterCondition((List)Lists.newArrayList((Object[])new ConvertibleCondition[]{itemLaunchIdConditionBuilder.withOperator(Operator.OR).build(), FilterCondition.builder().eq("retryParentLaunchId", String.valueOf(launch.getId())).withOperator(Operator.OR).build()}))).orElseGet(() -> ((FilterCondition.ConditionBuilder)itemLaunchIdConditionBuilder).build());
        filterable.getFilterConditions().add(launchIdCondition);
    }

    private void updatePathCondition(TestItem testItem, Filter filterable) {
        List resultConditions = filterable.getFilterConditions().stream().flatMap(c -> c.getAllConditions().stream()).filter(c -> BooleanUtils.isFalse((Boolean)("path".equals(c.getSearchCriteria()) && Condition.UNDER.equals((Object)c.getCondition()) ? 1 : 0))).collect(Collectors.toList());
        filterable.getFilterConditions().clear();
        FilterCondition parentPathCondition = this.getParentPathCondition(testItem);
        resultConditions.add(Optional.ofNullable(testItem.getRetryOf()).map(retryParent -> new CompositeFilterCondition((List)Lists.newArrayList((Object[])new ConvertibleCondition[]{parentPathCondition, FilterCondition.builder().withOperator(Operator.OR).withCondition(Condition.UNDER).withSearchCriteria("path").withValue(String.valueOf(testItem.getPath())).build()}))).orElse((ConvertibleCondition)parentPathCondition));
        filterable.getFilterConditions().addAll(resultConditions);
    }

    private FilterCondition getParentPathCondition(TestItem parent) {
        String pathValue = Optional.ofNullable(parent.getRetryOf()).flatMap(retryParentId -> Optional.ofNullable(parent.getParentId()).flatMap(arg_0 -> ((TestItemRepository)this.testItemRepository).findById(arg_0)).map(retryParent -> retryParent.getPath() + "." + parent.getItemId())).orElse(parent.getPath());
        return FilterCondition.builder().withCondition(Condition.UNDER).withSearchCriteria("path").withValue(pathValue).build();
    }

    private boolean isLogsExclusionRequired(TestItem parent, boolean excludePassedLogs) {
        if (excludePassedLogs) {
            return Stream.of(StatusEnum.values()).filter(StatusEnum::isPositive).anyMatch(s -> s == parent.getItemResults().getStatus());
        }
        return false;
    }
}

