/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.launch.impl;

import com.epam.reportportal.model.project.AnalyzerConfig;
import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.commons.validation.Suppliers;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.analyzer.auto.LogIndexer;
import com.epam.ta.reportportal.core.analyzer.auto.impl.AnalyzerUtils;
import com.epam.ta.reportportal.core.analyzer.config.AnalyzerType;
import com.epam.ta.reportportal.core.analyzer.strategy.LaunchAnalysisStrategy;
import com.epam.ta.reportportal.core.item.impl.LaunchAccessValidator;
import com.epam.ta.reportportal.core.launch.GetLaunchHandler;
import com.epam.ta.reportportal.core.launch.UpdateLaunchHandler;
import com.epam.ta.reportportal.core.launch.attribute.LaunchAttributeHandlerService;
import com.epam.ta.reportportal.core.launch.cluster.UniqueErrorAnalysisStarter;
import com.epam.ta.reportportal.core.launch.cluster.config.ClusterEntityContext;
import com.epam.ta.reportportal.core.project.GetProjectHandler;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.entity.ItemAttribute;
import com.epam.ta.reportportal.entity.enums.LaunchModeEnum;
import com.epam.ta.reportportal.entity.enums.ProjectAttributeEnum;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.entity.project.ProjectRole;
import com.epam.ta.reportportal.entity.project.ProjectUtils;
import com.epam.ta.reportportal.entity.user.UserRole;
import com.epam.ta.reportportal.model.BulkRQ;
import com.epam.ta.reportportal.model.launch.AnalyzeLaunchRQ;
import com.epam.ta.reportportal.model.launch.UpdateLaunchRQ;
import com.epam.ta.reportportal.model.launch.cluster.CreateClustersRQ;
import com.epam.ta.reportportal.util.ItemInfoUtils;
import com.epam.ta.reportportal.ws.converter.builders.LaunchBuilder;
import com.epam.ta.reportportal.ws.converter.converters.ItemAttributeConverter;
import com.epam.ta.reportportal.ws.reporting.BulkInfoUpdateRQ;
import com.epam.ta.reportportal.ws.reporting.Mode;
import com.epam.ta.reportportal.ws.reporting.OperationCompletionRS;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UpdateLaunchHandlerImpl
implements UpdateLaunchHandler {
    private final GetProjectHandler getProjectHandler;
    private final GetLaunchHandler getLaunchHandler;
    private final LaunchAccessValidator launchAccessValidator;
    private final LaunchRepository launchRepository;
    private final LogIndexer logIndexer;
    private final Map<AnalyzerType, LaunchAnalysisStrategy> launchAnalysisStrategyMapping;
    private final UniqueErrorAnalysisStarter uniqueErrorAnalysisStarter;
    private final LaunchAttributeHandlerService launchAttributeHandlerService;

    @Autowired
    public UpdateLaunchHandlerImpl(GetProjectHandler getProjectHandler, GetLaunchHandler getLaunchHandler, LaunchAccessValidator launchAccessValidator, LaunchRepository launchRepository, LogIndexer logIndexer, Map<AnalyzerType, LaunchAnalysisStrategy> launchAnalysisStrategyMapping, @Qualifier(value="uniqueErrorAnalysisStarterAsync") UniqueErrorAnalysisStarter uniqueErrorAnalysisStarter, LaunchAttributeHandlerService launchAttributeHandlerService) {
        this.getProjectHandler = getProjectHandler;
        this.getLaunchHandler = getLaunchHandler;
        this.launchAccessValidator = launchAccessValidator;
        this.launchRepository = launchRepository;
        this.launchAnalysisStrategyMapping = launchAnalysisStrategyMapping;
        this.logIndexer = logIndexer;
        this.uniqueErrorAnalysisStarter = uniqueErrorAnalysisStarter;
        this.launchAttributeHandlerService = launchAttributeHandlerService;
    }

    @Override
    public OperationCompletionRS updateLaunch(Long launchId, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user, UpdateLaunchRQ rq) {
        Project project = this.getProjectHandler.get(projectDetails);
        Launch launch = (Launch)this.launchRepository.findById((Object)launchId).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{launchId.toString()}));
        this.validate(launch, user, projectDetails, rq.getMode());
        LaunchModeEnum previousMode = launch.getMode();
        launch = new LaunchBuilder(launch).addMode(rq.getMode()).addDescription(rq.getDescription()).overwriteAttributes(rq.getAttributes()).get();
        this.launchAttributeHandlerService.handleLaunchUpdate(launch, user);
        this.launchRepository.save((Object)launch);
        if (!previousMode.equals((Object)launch.getMode())) {
            this.reindexLogs(launch, AnalyzerUtils.getAnalyzerConfig(project), project.getId());
        }
        return new OperationCompletionRS("Launch with ID = '" + launch.getId() + "' successfully updated.");
    }

    @Override
    public List<OperationCompletionRS> updateLaunch(BulkRQ<Long, UpdateLaunchRQ> rq, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        return rq.getEntities().entrySet().stream().map(entry -> this.updateLaunch((Long)entry.getKey(), projectDetails, user, (UpdateLaunchRQ)entry.getValue())).collect(Collectors.toList());
    }

    @Override
    public OperationCompletionRS startLaunchAnalyzer(AnalyzeLaunchRQ analyzeRQ, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        AnalyzerType analyzerType = AnalyzerType.fromString(analyzeRQ.getAnalyzerTypeName());
        this.launchAnalysisStrategyMapping.get((Object)analyzerType).analyze(analyzeRQ, projectDetails, user);
        return new OperationCompletionRS(analyzerType.getName() + " analysis for launch with ID='" + analyzeRQ.getLaunchId() + "' started.");
    }

    @Override
    @Transactional
    public OperationCompletionRS createClusters(CreateClustersRQ createClustersRQ, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        Launch launch = this.getLaunchHandler.get(createClustersRQ.getLaunchId());
        this.launchAccessValidator.validate(launch, projectDetails, user);
        BusinessRule.expect((Object)launch.getStatus(), (Predicate)Predicates.not((Predicate)Preconditions.statusIn((StatusEnum[])new StatusEnum[]{StatusEnum.IN_PROGRESS}))).verify(ErrorType.INCORRECT_REQUEST, new Object[]{"Cannot analyze launch in progress."});
        Project project = this.getProjectHandler.get(launch.getProjectId());
        Map configParameters = ProjectUtils.getConfigParameters((Set)project.getProjectAttributes());
        configParameters.put(ProjectAttributeEnum.UNIQUE_ERROR_ANALYZER_REMOVE_NUMBERS.getAttribute(), String.valueOf(createClustersRQ.isRemoveNumbers()));
        this.uniqueErrorAnalysisStarter.start(ClusterEntityContext.of(launch.getId(), launch.getProjectId()), configParameters);
        return new OperationCompletionRS((String)Suppliers.formattedSupplier((String)"Clusters generation for launch with ID='{}' started.", (Object[])new Object[]{launch.getId()}).get());
    }

    @Override
    public OperationCompletionRS bulkInfoUpdate(BulkInfoUpdateRQ bulkUpdateRq, ReportPortalUser.ProjectDetails projectDetails) {
        BusinessRule.expect((Object)this.getProjectHandler.exists(projectDetails.getProjectId()), Predicate.isEqual(true)).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectDetails.getProjectId()});
        List launches = this.launchRepository.findAllById((Iterable)bulkUpdateRq.getIds());
        launches.forEach(it -> ItemInfoUtils.updateDescription(bulkUpdateRq.getDescription(), it.getDescription()).ifPresent(arg_0 -> ((Launch)it).setDescription(arg_0)));
        bulkUpdateRq.getAttributes().forEach(it -> {
            switch (it.getAction()) {
                case DELETE: {
                    launches.forEach(launch -> {
                        ItemAttribute toDelete = ItemInfoUtils.findAttributeByResource(launch.getAttributes(), it.getFrom());
                        launch.getAttributes().remove(toDelete);
                    });
                    break;
                }
                case UPDATE: {
                    launches.forEach(launch -> ItemInfoUtils.updateAttribute(launch.getAttributes(), it));
                    break;
                }
                case CREATE: {
                    launches.stream().filter(launch -> ItemInfoUtils.containsAttribute(launch.getAttributes(), it.getTo())).forEach(launch -> {
                        ItemAttribute itemAttribute = ItemAttributeConverter.FROM_RESOURCE.apply(it.getTo());
                        itemAttribute.setLaunch(launch);
                        launch.getAttributes().add(itemAttribute);
                    });
                }
            }
        });
        return new OperationCompletionRS("Attributes successfully updated");
    }

    private void reindexLogs(Launch launch, AnalyzerConfig analyzerConfig, Long projectId) {
        if (LaunchModeEnum.DEBUG.equals((Object)launch.getMode())) {
            this.logIndexer.indexLaunchesRemove(projectId, Lists.newArrayList((Object[])new Long[]{launch.getId()}));
        } else {
            this.logIndexer.indexLaunchLogs(launch, analyzerConfig);
        }
    }

    private void validate(Launch launch, ReportPortalUser user, ReportPortalUser.ProjectDetails projectDetails, Mode mode) {
        if (projectDetails.getProjectRole() == ProjectRole.CUSTOMER && null != mode) {
            BusinessRule.expect((Object)mode, (Predicate)Predicates.equalTo((Object)Mode.DEFAULT)).verify(ErrorType.ACCESS_DENIED, new Object[0]);
        }
        if (user.getUserRole() != UserRole.ADMINISTRATOR) {
            BusinessRule.expect((Object)launch.getProjectId(), (Predicate)Predicates.equalTo((Object)projectDetails.getProjectId())).verify(ErrorType.ACCESS_DENIED, new Object[0]);
            if (projectDetails.getProjectRole().lowerThan(ProjectRole.PROJECT_MANAGER)) {
                BusinessRule.expect((Object)user.getUserId(), Predicate.isEqual(launch.getUserId())).verify(ErrorType.ACCESS_DENIED, new Object[0]);
            }
        }
    }
}

