/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.launch.impl;

import com.epam.reportportal.extension.event.StartLaunchEvent;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.LaunchStartedEvent;
import com.epam.ta.reportportal.core.launch.StartLaunchHandler;
import com.epam.ta.reportportal.core.launch.attribute.LaunchAttributeHandlerService;
import com.epam.ta.reportportal.core.launch.rerun.RerunHandler;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.ws.converter.builders.LaunchBuilder;
import com.epam.ta.reportportal.ws.converter.converters.LaunchConverter;
import com.epam.ta.reportportal.ws.reporting.StartLaunchRQ;
import com.epam.ta.reportportal.ws.reporting.StartLaunchRS;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Primary
@Transactional
public class StartLaunchHandlerImpl
implements StartLaunchHandler {
    private final LaunchRepository launchRepository;
    private final ApplicationEventPublisher eventPublisher;
    private final MessageBus messageBus;
    private final RerunHandler rerunHandler;
    private final LaunchAttributeHandlerService launchAttributeHandlerService;

    @Autowired
    public StartLaunchHandlerImpl(LaunchRepository launchRepository, ApplicationEventPublisher eventPublisher, MessageBus messageBus, RerunHandler rerunHandler, LaunchAttributeHandlerService launchAttributeHandlerService) {
        this.launchRepository = launchRepository;
        this.eventPublisher = eventPublisher;
        this.messageBus = messageBus;
        this.rerunHandler = rerunHandler;
        this.launchAttributeHandlerService = launchAttributeHandlerService;
    }

    @Override
    @Transactional
    public StartLaunchRS startLaunch(ReportPortalUser user, ReportPortalUser.ProjectDetails projectDetails, StartLaunchRQ request) {
        this.validateRoles(projectDetails, request);
        Launch savedLaunch = Optional.of(request.isRerun()).filter(Boolean::booleanValue).map(rerun -> this.rerunHandler.handleLaunch(request, projectDetails.getProjectId(), user)).orElseGet(() -> {
            Launch launch = new LaunchBuilder().addStartRQ(request).addAttributes(request.getAttributes()).addProject(projectDetails.getProjectId()).addUserId(user.getUserId()).get();
            this.launchAttributeHandlerService.handleLaunchStart(launch);
            this.launchRepository.save((Object)launch);
            this.launchRepository.refresh((Object)launch);
            return launch;
        });
        this.eventPublisher.publishEvent((ApplicationEvent)new StartLaunchEvent(savedLaunch.getId()));
        this.messageBus.publishActivity(new LaunchStartedEvent(LaunchConverter.TO_ACTIVITY_RESOURCE.apply(savedLaunch), user.getUserId(), user.getUsername()));
        StartLaunchRS response = new StartLaunchRS();
        response.setId(savedLaunch.getUuid());
        response.setNumber(savedLaunch.getNumber());
        return response;
    }
}

