/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.launch.impl;

import com.epam.reportportal.extension.event.GetLaunchResourceCollectionEvent;
import com.epam.reportportal.model.launch.cluster.ClusterInfoResource;
import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.commons.validation.Suppliers;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.Condition;
import com.epam.ta.reportportal.commons.querygen.ConvertibleCondition;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.FilterCondition;
import com.epam.ta.reportportal.commons.querygen.ProjectFilter;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.core.jasper.GetJasperReportHandler;
import com.epam.ta.reportportal.core.jasper.util.JasperDataProvider;
import com.epam.ta.reportportal.core.launch.GetLaunchHandler;
import com.epam.ta.reportportal.core.launch.cluster.GetClusterHandler;
import com.epam.ta.reportportal.dao.ItemAttributeRepository;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.dao.UserRepository;
import com.epam.ta.reportportal.dao.WidgetContentRepository;
import com.epam.ta.reportportal.entity.enums.LaunchModeEnum;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.jasper.ReportFormat;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.entity.project.ProjectRole;
import com.epam.ta.reportportal.entity.user.User;
import com.epam.ta.reportportal.entity.widget.content.ChartStatisticsContent;
import com.epam.ta.reportportal.ws.converter.PagedResourcesAssembler;
import com.epam.ta.reportportal.ws.converter.converters.LaunchConverter;
import com.epam.ta.reportportal.ws.reporting.LaunchResource;
import com.epam.ta.reportportal.ws.reporting.Mode;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JasperPrint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GetLaunchHandlerImpl
implements GetLaunchHandler {
    private final GetClusterHandler getClusterHandler;
    private final LaunchRepository launchRepository;
    private final TestItemRepository testItemRepository;
    private final ItemAttributeRepository itemAttributeRepository;
    private final ProjectRepository projectRepository;
    private final WidgetContentRepository widgetContentRepository;
    private final UserRepository userRepository;
    private final JasperDataProvider dataProvider;
    private final GetJasperReportHandler<Launch> jasperReportHandler;
    private final LaunchConverter launchConverter;
    private final ApplicationEventPublisher applicationEventPublisher;

    @Autowired
    public GetLaunchHandlerImpl(GetClusterHandler getClusterHandler, LaunchRepository launchRepository, TestItemRepository testItemRepository, ItemAttributeRepository itemAttributeRepository, ProjectRepository projectRepository, WidgetContentRepository widgetContentRepository, UserRepository userRepository, JasperDataProvider dataProvider, @Qualifier(value="launchJasperReportHandler") GetJasperReportHandler<Launch> jasperReportHandler, LaunchConverter launchConverter, ApplicationEventPublisher applicationEventPublisher) {
        this.getClusterHandler = getClusterHandler;
        this.launchRepository = launchRepository;
        this.testItemRepository = testItemRepository;
        this.itemAttributeRepository = itemAttributeRepository;
        this.projectRepository = projectRepository;
        this.widgetContentRepository = widgetContentRepository;
        this.userRepository = userRepository;
        this.dataProvider = (JasperDataProvider)Preconditions.checkNotNull((Object)dataProvider);
        this.jasperReportHandler = jasperReportHandler;
        this.launchConverter = launchConverter;
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @Override
    public Launch get(Long id) {
        return (Launch)this.launchRepository.findById((Object)id).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{id}));
    }

    @Override
    public LaunchResource getLaunch(String launchId, ReportPortalUser.ProjectDetails projectDetails) {
        Launch launch = this.findLaunch(launchId, projectDetails);
        return this.getLaunchResource(launch);
    }

    private Launch findLaunch(String launchId, ReportPortalUser.ProjectDetails projectDetails) {
        Launch launch;
        try {
            launch = this.get(Long.parseLong(launchId));
        }
        catch (NumberFormatException e) {
            launch = (Launch)this.launchRepository.findByUuid(launchId).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{launchId}));
        }
        this.validate(launch, projectDetails);
        return launch;
    }

    @Override
    public LaunchResource getLaunchByProjectName(String projectName, Pageable pageable, Filter filter, String username) {
        Project project = (Project)this.projectRepository.findByName(projectName).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName}));
        Page launches = this.launchRepository.findByFilter((Queryable)ProjectFilter.of((Queryable)filter, (Long)project.getId()), pageable);
        BusinessRule.expect((Object)launches, (Predicate)Predicates.notNull()).verify(ErrorType.LAUNCH_NOT_FOUND, new Object[0]);
        return this.getLaunchResource((Launch)launches.iterator().next());
    }

    private LaunchResource getLaunchResource(Launch launch) {
        LaunchResource launchResource = this.launchConverter.TO_RESOURCE.apply(launch);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new GetLaunchResourceCollectionEvent(Collections.singletonList(launchResource)));
        return launchResource;
    }

    @Override
    public com.epam.ta.reportportal.model.Page<LaunchResource> getProjectLaunches(ReportPortalUser.ProjectDetails projectDetails, Filter filter, Pageable pageable, String userName) {
        this.validateModeConditions(filter);
        Project project = (Project)this.projectRepository.findById((Object)projectDetails.getProjectId()).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectDetails.getProjectId()}));
        filter = this.addLaunchCommonCriteria(Mode.DEFAULT, filter);
        Page launches = this.launchRepository.findByFilter((Queryable)ProjectFilter.of((Queryable)filter, (Long)project.getId()), pageable);
        return this.getLaunchResources((Page<Launch>)launches);
    }

    @Override
    public com.epam.ta.reportportal.model.Page<LaunchResource> getDebugLaunches(ReportPortalUser.ProjectDetails projectDetails, Filter filter, Pageable pageable) {
        this.validateModeConditions(filter);
        filter = this.addLaunchCommonCriteria(Mode.DEBUG, filter);
        Page launches = this.launchRepository.findByFilter((Queryable)ProjectFilter.of((Queryable)filter, (Long)projectDetails.getProjectId()), pageable);
        return this.getLaunchResources((Page<Launch>)launches);
    }

    @Override
    public List<String> getAttributeKeys(ReportPortalUser.ProjectDetails projectDetails, String value) {
        return this.itemAttributeRepository.findLaunchAttributeKeys(projectDetails.getProjectId(), value, false);
    }

    @Override
    public List<String> getAttributeValues(ReportPortalUser.ProjectDetails projectDetails, String key, String value) {
        return this.itemAttributeRepository.findLaunchAttributeValues(projectDetails.getProjectId(), key, value, false);
    }

    @Override
    public com.epam.ta.reportportal.model.Page<LaunchResource> getLatestLaunches(ReportPortalUser.ProjectDetails projectDetails, Filter filter, Pageable pageable) {
        this.validateModeConditions(filter);
        Project project = (Project)this.projectRepository.findById((Object)projectDetails.getProjectId()).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectDetails.getProjectId()}));
        filter = this.addLaunchCommonCriteria(Mode.DEFAULT, filter);
        Page launches = this.launchRepository.findAllLatestByFilter((Queryable)ProjectFilter.of((Queryable)filter, (Long)project.getId()), pageable);
        return this.getLaunchResources((Page<Launch>)launches);
    }

    @Override
    @Transactional(readOnly=true)
    public com.epam.ta.reportportal.model.Page<ClusterInfoResource> getClusters(String launchId, ReportPortalUser.ProjectDetails projectDetails, Pageable pageable) {
        Launch launch = this.findLaunch(launchId, projectDetails);
        return this.getClusterHandler.getResources(launch, pageable);
    }

    @Override
    public boolean hasItemsWithIssues(Launch launch) {
        return this.testItemRepository.hasItemsWithIssueByLaunch(launch.getId());
    }

    private com.epam.ta.reportportal.model.Page<LaunchResource> getLaunchResources(Page<Launch> launches) {
        com.epam.ta.reportportal.model.Page<LaunchResource> launchResourcePage = PagedResourcesAssembler.pageConverter(this.launchConverter.TO_RESOURCE).apply(launches);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new GetLaunchResourceCollectionEvent(launchResourcePage.getContent()));
        return launchResourcePage;
    }

    @Override
    public List<String> getLaunchNames(ReportPortalUser.ProjectDetails projectDetails, String value) {
        BusinessRule.expect((Object)(value.length() <= 256 ? 1 : 0), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.INCORRECT_FILTER_PARAMETERS, new Object[]{Suppliers.formattedSupplier((String)"Length of the launch name string '{}' more than {} symbols", (Object[])new Object[]{value, 256})});
        return this.launchRepository.getLaunchNamesByModeExcludedByStatus(projectDetails.getProjectId(), value, LaunchModeEnum.DEFAULT, StatusEnum.IN_PROGRESS);
    }

    @Override
    public List<String> getOwners(ReportPortalUser.ProjectDetails projectDetails, String value, String mode) {
        BusinessRule.expect((Object)(value.length() > 2 ? 1 : 0), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.INCORRECT_FILTER_PARAMETERS, new Object[]{Suppliers.formattedSupplier((String)"Length of the filtering string '{}' is less than 3 symbols", (Object[])new Object[]{value})});
        LaunchModeEnum launchMode = (LaunchModeEnum)LaunchModeEnum.findByName((String)mode).orElseThrow(() -> new ReportPortalException(ErrorType.INCORRECT_FILTER_PARAMETERS, new Object[]{Suppliers.formattedSupplier((String)"Mode - {} doesn't exist.", (Object[])new Object[]{mode})}));
        return this.launchRepository.getOwnerNames(projectDetails.getProjectId(), value, launchMode.name());
    }

    @Override
    public Map<String, List<ChartStatisticsContent>> getLaunchesComparisonInfo(ReportPortalUser.ProjectDetails projectDetails, Long[] ids) {
        ArrayList contentFields = Lists.newArrayList((Object[])new String[]{"statistics$defects$automation_bug$total", "statistics$defects$no_defect$total", "statistics$defects$product_bug$total", "statistics$defects$system_issue$total", "statistics$defects$to_investigate$total", "statistics$executions$failed", "statistics$executions$passed", "statistics$executions$skipped"});
        Filter filter = Filter.builder().withTarget(Launch.class).withCondition((ConvertibleCondition)new FilterCondition(Condition.IN, false, Arrays.stream(ids).map(String::valueOf).collect(Collectors.joining(",")), "id")).withCondition((ConvertibleCondition)new FilterCondition(Condition.EQUALS, false, String.valueOf(projectDetails.getProjectId()), "projectId")).build();
        List result = this.widgetContentRepository.launchesComparisonStatistics(filter, (List)contentFields, Sort.unsorted(), ids.length);
        return Collections.singletonMap("result", result);
    }

    @Override
    public Map<String, String> getStatuses(ReportPortalUser.ProjectDetails projectDetails, Long[] ids) {
        return this.launchRepository.getStatuses(projectDetails.getProjectId(), ids);
    }

    @Override
    public void exportLaunch(Long launchId, ReportFormat reportFormat, OutputStream outputStream, ReportPortalUser user) {
        Launch launch = (Launch)this.launchRepository.findById((Object)launchId).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{launchId}));
        BusinessRule.expect((Object)launch.getStatus(), (Predicate)Predicates.not((Predicate)com.epam.ta.reportportal.commons.Preconditions.statusIn((StatusEnum[])new StatusEnum[]{StatusEnum.IN_PROGRESS}))).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{Suppliers.formattedSupplier((String)"Launch '{}' has IN_PROGRESS status. Impossible to export such elements.", (Object[])new Object[]{launchId})});
        String userFullName = this.userRepository.findById((Object)user.getUserId()).map(User::getFullName).orElseThrow(() -> new ReportPortalException(ErrorType.USER_NOT_FOUND, new Object[]{user.getUserId()}));
        Map<String, Object> params = this.jasperReportHandler.convertParams(launch);
        this.fillWithAdditionalParams(params, launch, userFullName);
        JasperPrint jasperPrint = this.jasperReportHandler.getJasperPrint(params, (JRDataSource)new JREmptyDataSource());
        this.jasperReportHandler.writeReport(reportFormat, outputStream, jasperPrint);
    }

    private void validate(Launch launch, ReportPortalUser.ProjectDetails projectDetails) {
        BusinessRule.expect((Object)launch.getProjectId(), (Predicate)Predicates.equalTo((Object)projectDetails.getProjectId())).verify(ErrorType.ACCESS_DENIED, new Object[0]);
        if (LaunchModeEnum.DEBUG.equals((Object)launch.getMode())) {
            BusinessRule.expect((Object)projectDetails.getProjectRole(), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)ProjectRole.CUSTOMER))).verify(ErrorType.ACCESS_DENIED, new Object[0]);
        }
    }

    private Filter addLaunchCommonCriteria(Mode mode, Filter filter) {
        return Optional.ofNullable(filter).orElseGet(() -> new Filter(Launch.class, (List)Lists.newArrayList())).withCondition((ConvertibleCondition)FilterCondition.builder().eq("mode", mode.name()).build());
    }

    private void validateModeConditions(Filter filter) {
        BusinessRule.expect((Object)filter.getFilterConditions().stream().map(ConvertibleCondition::getAllConditions).flatMap(Collection::stream).anyMatch(com.epam.ta.reportportal.commons.Preconditions.HAS_ANY_MODE), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.INCORRECT_FILTER_PARAMETERS, new Object[]{"Filters for 'mode' aren't applicable for project's launches."});
    }

    private void fillWithAdditionalParams(Map<String, Object> params, Launch launch, String userFullName) {
        Optional<String> owner = this.userRepository.findById((Object)launch.getUserId()).map(User::getFullName);
        params.put("LAUNCH_OWNER", owner.orElse(userFullName));
        params.put("TEST_ITEMS", this.dataProvider.getTestItemsOfLaunch(launch));
    }
}

