/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.launch.cluster.pipeline.data;

import com.epam.reportportal.model.analyzer.IndexLaunch;
import com.epam.reportportal.model.project.AnalyzerConfig;
import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.ta.reportportal.core.analyzer.auto.client.AnalyzerServiceClient;
import com.epam.ta.reportportal.core.analyzer.auto.client.model.cluster.ClusterData;
import com.epam.ta.reportportal.core.analyzer.auto.client.model.cluster.GenerateClustersRq;
import com.epam.ta.reportportal.core.launch.cluster.config.ClusterEntityContext;
import com.epam.ta.reportportal.core.launch.cluster.config.GenerateClustersConfig;
import com.epam.ta.reportportal.core.launch.cluster.pipeline.data.ClusterDataProvider;
import java.util.Optional;
import java.util.function.Predicate;

public abstract class AnalyzerClusterDataProvider
implements ClusterDataProvider {
    private final AnalyzerServiceClient analyzerServiceClient;

    public AnalyzerClusterDataProvider(AnalyzerServiceClient analyzerServiceClient) {
        this.analyzerServiceClient = analyzerServiceClient;
    }

    protected abstract Optional<IndexLaunch> prepareIndexLaunch(GenerateClustersConfig var1);

    @Override
    public Optional<ClusterData> provide(GenerateClustersConfig config) {
        BusinessRule.expect((Object)this.analyzerServiceClient.hasClients(), Predicate.isEqual(true)).verify(ErrorType.UNABLE_INTERACT_WITH_INTEGRATION, new Object[]{"There are no analyzer services are deployed."});
        return this.getGenerateRq(config).map(this.analyzerServiceClient::generateClusters);
    }

    private Optional<GenerateClustersRq> getGenerateRq(GenerateClustersConfig config) {
        return this.prepareIndexLaunch(config).map(indexLaunch -> {
            GenerateClustersRq generateClustersRq = new GenerateClustersRq();
            generateClustersRq.setLaunch((IndexLaunch)indexLaunch);
            generateClustersRq.setCleanNumbers(config.isCleanNumbers());
            generateClustersRq.setForUpdate(config.isForUpdate());
            ClusterEntityContext entityContext = config.getEntityContext();
            generateClustersRq.setProject(entityContext.getProjectId());
            AnalyzerConfig analyzerConfig = config.getAnalyzerConfig();
            generateClustersRq.setNumberOfLogLines(analyzerConfig.getNumberOfLogLines());
            return generateClustersRq;
        });
    }
}

