/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.launch.cluster.pipeline;

import com.epam.ta.reportportal.core.launch.cluster.config.ClusterEntityContext;
import com.epam.ta.reportportal.core.launch.cluster.config.GenerateClustersConfig;
import com.epam.ta.reportportal.dao.ItemAttributeRepository;
import com.epam.ta.reportportal.pipeline.PipelinePart;
import com.epam.ta.reportportal.pipeline.PipelinePartProvider;
import java.time.Instant;

public class SaveLastRunAttributePartProvider
implements PipelinePartProvider<GenerateClustersConfig> {
    public static final String RP_CLUSTER_LAST_RUN_KEY = "rp.cluster.lastRun";
    private final ItemAttributeRepository itemAttributeRepository;

    public SaveLastRunAttributePartProvider(ItemAttributeRepository itemAttributeRepository) {
        this.itemAttributeRepository = itemAttributeRepository;
    }

    @Override
    public PipelinePart provide(GenerateClustersConfig config) {
        return () -> {
            if (config.isForUpdate()) {
                return;
            }
            String lastRunDate = String.valueOf(Instant.now().toEpochMilli());
            ClusterEntityContext entityContext = config.getEntityContext();
            this.itemAttributeRepository.deleteAllByLaunchIdAndKeyAndSystem(entityContext.getLaunchId(), RP_CLUSTER_LAST_RUN_KEY, true);
            this.itemAttributeRepository.saveByLaunchId(entityContext.getLaunchId(), RP_CLUSTER_LAST_RUN_KEY, lastRunDate, true);
        };
    }
}

