/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.launch.cluster.pipeline;

import com.epam.ta.reportportal.core.launch.cluster.config.ClusterEntityContext;
import com.epam.ta.reportportal.core.launch.cluster.config.GenerateClustersConfig;
import com.epam.ta.reportportal.dao.ClusterRepository;
import com.epam.ta.reportportal.dao.LogRepository;
import com.epam.ta.reportportal.pipeline.PipelinePart;
import com.epam.ta.reportportal.pipeline.PipelinePartProvider;

public class DeleteClustersPartProvider
implements PipelinePartProvider<GenerateClustersConfig> {
    private final ClusterRepository clusterRepository;
    private final LogRepository logRepository;

    public DeleteClustersPartProvider(ClusterRepository clusterRepository, LogRepository logRepository) {
        this.clusterRepository = clusterRepository;
        this.logRepository = logRepository;
    }

    @Override
    public PipelinePart provide(GenerateClustersConfig config) {
        return () -> {
            ClusterEntityContext entityContext = config.getEntityContext();
            if (config.isForUpdate()) {
                this.logRepository.updateClusterIdSetNullByItemIds(entityContext.getItemIds());
                this.clusterRepository.deleteClusterTestItemsByItemIds(entityContext.getItemIds());
            } else {
                this.logRepository.updateClusterIdSetNullByLaunchId(entityContext.getLaunchId());
                this.clusterRepository.deleteClusterTestItemsByLaunchId(entityContext.getLaunchId());
                this.clusterRepository.deleteAllByLaunchId(entityContext.getLaunchId());
            }
        };
    }
}

