/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.jasper;

import com.epam.ta.reportportal.entity.jasper.ReportType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Service;

@Service(value="jasperRender")
public class JasperReportRender {
    private static final Logger LOGGER = LoggerFactory.getLogger(JasperReportRender.class);
    private static final String PROJECTS_REPORT_JRXML_TEMPLATE = "classpath:/templates/report/projects.jrxml";
    private static final String USERS_REPORT_JRXML_TEMPLATE = "classpath:/templates/report/users.jrxml";
    private static final String LAUNCH_REPORT_JRXML_TEMPLATE = "classpath:/templates/report/report.jrxml";
    private static final Map<ReportType, String> reportTypeTemplatePathMapping = ImmutableMap.builder().put((Object)ReportType.PROJECT, (Object)"classpath:/templates/report/projects.jrxml").put((Object)ReportType.USER, (Object)"classpath:/templates/report/users.jrxml").put((Object)ReportType.LAUNCH, (Object)"classpath:/templates/report/report.jrxml").build();
    private final Map<ReportType, JasperReport> reportTemplatesMapping;

    @Autowired
    public JasperReportRender(ResourceLoader resourceLoader) throws JRException, IOException {
        ImmutableMap.Builder reportTypeJasperReportBuilder = ImmutableMap.builder();
        for (Map.Entry<ReportType, String> entry : reportTypeTemplatePathMapping.entrySet()) {
            Resource reportTemplate = resourceLoader.getResource(entry.getValue());
            Preconditions.checkArgument((boolean)reportTemplate.exists());
            InputStream inputStream = reportTemplate.getInputStream();
            try {
                JasperDesign jasperDesign = JRXmlLoader.load((InputStream)inputStream);
                reportTypeJasperReportBuilder.put((Object)entry.getKey(), (Object)JasperCompileManager.compileReport((JasperDesign)jasperDesign));
            }
            finally {
                if (inputStream == null) continue;
                inputStream.close();
            }
        }
        this.reportTemplatesMapping = reportTypeJasperReportBuilder.build();
    }

    public JasperPrint generateReportPrint(ReportType reportType, Map<String, Object> params, JRDataSource datasource) {
        try {
            return JasperFillManager.fillReport((JasperReport)this.reportTemplatesMapping.get(reportType), params, (JRDataSource)datasource);
        }
        catch (JRException e) {
            LOGGER.error("Unable to generate Report", (Throwable)e);
            return new JasperPrint();
        }
    }
}

