/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.impl.retry;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.ta.reportportal.core.events.activity.item.ItemRetryEvent;
import com.epam.ta.reportportal.core.item.impl.retry.RetryHandler;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.jooq.enums.JStatusEnum;
import java.time.Instant;
import java.util.Objects;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public class DefaultRetryHandler
implements RetryHandler {
    private final TestItemRepository testItemRepository;
    private final LaunchRepository launchRepository;
    private final ApplicationEventPublisher eventPublisher;

    public DefaultRetryHandler(TestItemRepository testItemRepository, LaunchRepository launchRepository, ApplicationEventPublisher eventPublisher) {
        this.testItemRepository = testItemRepository;
        this.launchRepository = launchRepository;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void handleRetries(Launch launch, TestItem newRetryParent, Long previousParent) {
        this.handleRetries(launch, previousParent, newRetryParent);
        this.eventPublisher.publishEvent((Object)ItemRetryEvent.of(launch.getProjectId(), launch.getId(), newRetryParent.getItemId()));
    }

    @Override
    public void finishRetries(Long retryParentId, JStatusEnum status, Instant endTime) {
        this.testItemRepository.updateStatusAndEndTimeByRetryOfId(retryParentId, JStatusEnum.IN_PROGRESS, JStatusEnum.valueOf((String)status.name()), endTime);
    }

    private void handleRetries(Launch launch, Long retryParent, TestItem newRetryParent) {
        this.validateNewParent(retryParent, newRetryParent);
        this.testItemRepository.handleRetry(retryParent, newRetryParent.getItemId());
        this.updateLaunchRetriesState(launch);
    }

    private void validateNewParent(Long prevRetryParent, TestItem newRetryParent) {
        BusinessRule.expect((Object)newRetryParent, i -> !i.getItemId().equals(prevRetryParent)).verify(ErrorType.RETRIES_HANDLER_ERROR, new Object[]{"Previous and new parent 'id' should not be equal"});
        BusinessRule.expect((Object)newRetryParent, i -> Objects.isNull(i.getRetryOf())).verify(ErrorType.RETRIES_HANDLER_ERROR, new Object[]{"Parent item should not be a retry"});
    }

    private void updateLaunchRetriesState(Launch launch) {
        if (!launch.isHasRetries()) {
            launch.setHasRetries(this.launchRepository.hasRetries(launch.getId()));
        }
    }
}

