/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.impl.provider.impl;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.CompositeFilter;
import com.epam.ta.reportportal.commons.querygen.ConvertibleCondition;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.FilterCondition;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.core.item.impl.provider.DataProviderHandler;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.dao.WidgetContentRepository;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.statistics.Statistics;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.jooq.Operator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class CumulativeTestItemDataProviderImpl
implements DataProviderHandler {
    @Autowired
    private WidgetContentRepository widgetContentRepository;
    @Autowired
    private TestItemRepository testItemRepository;

    @Override
    public Page<TestItem> getTestItems(Queryable filter, Pageable pageable, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user, Map<String, String> params) {
        filter = this.updateFilter(filter, params);
        return this.testItemRepository.findByFilter(filter, pageable);
    }

    @Override
    public Set<Statistics> accumulateStatistics(Queryable filter, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user, Map<String, String> params) {
        filter = this.updateFilter(filter, params);
        return this.testItemRepository.accumulateStatisticsByFilter(filter);
    }

    public Queryable updateFilter(Queryable filter, Map<String, String> providerParams) {
        String compositeAttribute = providerParams.get("filter.has.levelAttribute");
        BusinessRule.expect((Object)compositeAttribute, it -> !StringUtils.isEmpty((Object)it)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Level attributes must be provided for widget based items provider"});
        List redirectLaunchIds = this.widgetContentRepository.getCumulativeLevelRedirectLaunchIds(providerParams.get("viewName"), compositeAttribute);
        if (CollectionUtils.isNotEmpty((Collection)redirectLaunchIds)) {
            Filter launchesBasedFilter = Filter.builder().withTarget(TestItem.class).withCondition((ConvertibleCondition)FilterCondition.builder().in("launchId", redirectLaunchIds).build()).build();
            return new CompositeFilter(Operator.AND, new Queryable[]{filter, launchesBasedFilter});
        }
        return filter;
    }
}

