/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.impl.provider;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.core.item.impl.provider.DataProviderHandler;
import com.epam.ta.reportportal.core.item.utils.DefaultLaunchFilterProvider;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.dao.UserFilterRepository;
import com.epam.ta.reportportal.entity.filter.UserFilter;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.project.ProjectRole;
import com.epam.ta.reportportal.entity.statistics.Statistics;
import com.epam.ta.reportportal.entity.user.UserRole;
import com.epam.ta.reportportal.util.ControllerUtils;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class FilterDataProviderImpl
implements DataProviderHandler {
    private static final String FILTER_ID_PARAM = "filterId";
    @Autowired
    private UserFilterRepository filterRepository;
    @Autowired
    private TestItemRepository testItemRepository;

    @Override
    public Set<Statistics> accumulateStatistics(Queryable filter, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user, Map<String, String> params) {
        this.validateProjectRole(projectDetails, user);
        Optional.ofNullable(params.get(FILTER_ID_PARAM)).map(ControllerUtils::safeParseLong).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Filter id must be provided for filter based items provider"}));
        return this.testItemRepository.accumulateStatisticsByFilter(filter);
    }

    @Override
    public Page<TestItem> getTestItems(Queryable filter, Pageable pageable, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user, Map<String, String> params) {
        this.validateProjectRole(projectDetails, user);
        Long launchFilterId = Optional.ofNullable(params.get(FILTER_ID_PARAM)).map(ControllerUtils::safeParseLong).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Filter id must be provided for filter based items provider"}));
        Integer launchesLimit = Optional.ofNullable(params.get("launchesLimit")).map(ControllerUtils::safeParseInt).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Launches limit must be provided for filter based items provider"}));
        Boolean isLatest = Optional.ofNullable(params.get("isLatest")).map(Boolean::parseBoolean).orElse(false);
        UserFilter userFilter = (UserFilter)this.filterRepository.findByIdAndProjectId(launchFilterId, projectDetails.getProjectId()).orElseThrow(() -> new ReportPortalException(ErrorType.USER_FILTER_NOT_FOUND_IN_PROJECT, new Object[]{launchFilterId, projectDetails.getProjectName()}));
        Pair<Queryable, Pageable> queryablePair = DefaultLaunchFilterProvider.createDefaultLaunchQueryablePair(projectDetails, userFilter, launchesLimit);
        return this.testItemRepository.findByFilter(isLatest.booleanValue(), (Queryable)queryablePair.getKey(), filter, (Pageable)queryablePair.getValue(), pageable);
    }

    protected void validateProjectRole(ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        if (user.getUserRole() != UserRole.ADMINISTRATOR) {
            BusinessRule.expect((Object)(projectDetails.getProjectRole() == ProjectRole.OPERATOR ? 1 : 0), Predicate.isEqual(false)).verify(ErrorType.ACCESS_DENIED, new Object[0]);
        }
    }
}

